% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_metrics}
\alias{plot_metrics}
\title{Output a plot with distribution parameters such as the mean values}
\usage{
plot_metrics(data, cols, col_group = NULL, clean = TRUE, ...)
}
\arguments{
\item{data}{A data frame}

\item{cols}{A tidy column selection,
e.g. a single column (without quotes)
or multiple columns selected by methods such as starts_with().}

\item{col_group}{Optional, a grouping column (without quotes).}

\item{clean}{Prepare data by \link{data_clean}.}

\item{...}{Other parameters passed to the appropriate plot function}
}
\value{
A ggplot object
}
\description{
The table type depends on the number of selected columns:
\itemize{
\item One column: see \link{plot_metrics_one}
\item Multiple columns: see \link{plot_metrics_items}
\item One column and one grouping column: see \link{plot_metrics_one_grouped}
\item Multiple columns and one grouping column: see \link{plot_metrics_items_grouped}
}
}
\examples{
library(volker)
data <- volker::chatgpt

plot_metrics(data, sd_age)

}
