% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{matches}
\alias{matches}
\title{Matches data}
\format{Data frame with 3392 rows and 12 columns.
\describe{
  \item{league_gender}{Men or women's league.}
  \item{season_id}{ID for each season unique within league_gender. It consists of the last two digits of the season
  years, e.g., the season_id of season 2014/2015 equals 1415.}
  \item{competition_stage}{Stage of the competition, i.e., main round or play-offs.}
  \item{match_id}{Official VBL match id. Unique within seasons.}
  \item{match}{Factor variable identifying whether observation is from the home team's perspective or
  from the away team's perspective.}
  \item{match_day}{Match day (only main round, see competition_stage).}
  \item{date_time}{POSIXct date-time variable of the match.}
  \item{spectators}{Number of spectators in the gym.}
  \item{match_duration}{Length of match in minutes.}
  \item{team_id}{Team identifier which is unique across all teams and seasons.}
  \item{team_name}{Official name of the team. Note that VCO Berlin has a team in men's and women's league.}
  \item{set_won}{Number of sets won by the team.}
}}
\source{
\url{https://www.volleyball-bundesliga.de/cms/home/1blf/1blf_archiv/1blf_tabellen_ergebnisse.xhtml}
        \url{https://www.volleyball-bundesliga.de/cms/home/1blm/1blm_archiv/1blm_tabellen_ergebnisse.xhtml}
}
\usage{
matches
}
\description{
A dataset containing all matches of the German first division volleyball league for each season
starting in 2013/2014 and ending in 2018/2019. Note that all matches are included twice in the
dataset, i.e., from the perspective of the home team and from the perspective of the away team.
}
\examples{
matchstats
}
\keyword{datasets}
