% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSMD_matrix.R
\name{SSMD_matrix}
\alias{SSMD_matrix}
\title{Generate a SSMD matrix with all possible pairwise comparisons}
\usage{
SSMD_matrix(
  data,
  project,
  scenario,
  params = c("PExtinct", "Nextant", "Het", "Nalleles"),
  yrs = "max",
  ST = FALSE,
  save2disk = TRUE,
  dir_out = "DataAnalysis/SSMD_matrix"
)
}
\arguments{
\item{data}{A data.frame generated by \code{collate_dat}}

\item{project}{The Vortex project name}

\item{scenario}{The ST Vortex scenario name or the scenario that should be
used as baseline if simulations were not conducted with the ST module}

\item{params}{A character vector with the parameters to be compared,
default: c('PExtinct', 'Nextant', 'Het', 'Nalleles')}

\item{yrs}{The year(s) to be analysed, default: 'max'}

\item{ST}{Whether files are from sensitivity analysis (TRUE),
or not (FALSE, default)}

\item{save2disk}{Whether to save the output to disk, default: TRUE}

\item{dir_out}{The local path to store the output. Default: DataAnalysis/SSMD_matrix}
}
\value{
A list where each element is a matrix of SSMD (belowe the diagonal)
        and related p-values (above the diagonal) for each combination of 'yrs',
        population and 'params'
}
\description{
\code{SSMD_matrix} conducts pairwise comparisons for all possible pairs
using strictly standardised mean difference (SSDM, Zhang 2007).
}
\details{
When \code{yrs='max'} (default), VortexR automatically sets  \code{yrs} to
the last year of the simulation .
}
\examples{
# Using Campbell et al. and Pacioni et al. example data.
# See ?pacioni and ?campbell for more details on example data.
require(vortexRdata)

data("pac.clas")

SSMD_matrix(data=pac.clas, project="Pacioni_et_al",
scenario="ST_Classic",
params = c("PExtinct", "Nextant", "Het", "Nalleles"),
yrs = c(60, 120), ST = FALSE, save2disk = FALSE)

data(sta.main)
ssmd_mat <- SSMD_matrix(data=sta.main, project="test",
                       scenario="test",
                       params = c("PExtant", "Nextant"),
                       yrs = c(25, 50), ST = FALSE, save2disk = FALSE)
}
\references{
Zhang, X. D. 2007. A pair of new statistical parameters for quality control
in RNA interference high-throughput screening assays. Genomics 89:552-561.
}
