% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/votes_get_by_official.R
\name{votes_get_by_official}
\alias{votes_get_by_official}
\title{Get votes by official}
\usage{
votes_get_by_official(
  candidate_ids,
  office_ids = "",
  category_ids = "",
  years = "",
  all = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{candidate_ids}{Vector of candidate_ids (required). See \link{candidates_get_by_lastname}, \link{candidates_get_by_levenshtein}, and \link{candidates_get_by_office_state}.}

\item{office_ids}{Vector of office_ids. See \link{office_get_offices_by_level}.}

\item{category_ids}{Vector of category_ids. See \link{rating_get_categories}.}

\item{years}{Vector of years in which the vote was taken.}

\item{all}{Boolean: should all possible combinations of the variables be searched for, or just the exact combination of them in the order they are supplied?}

\item{verbose}{Should cases when no data is available be messaged?}
}
\value{
A dataframe of candidates' votes on bills and their attributes. If a given input combination returns no data, that row will be filled with \code{NA}s.
}
\description{
Get votes by official
}
\examples{
\dontrun{
aoc <- candidates_get_by_lastname(
  "ocasio-cortez",
  election_years = "2018"
)
votes_get_by_official(aoc$candidate_id)
}
}
