/*
 * Decompiled with CFR 0.152.
 */
class Expression {
    public Evaluator evaluator;
    public double current_value = 0.0;
    public double last_valid_value = 0.0;
    public Graphics3D graphics;
    public int point_index;
    public int coordinate_index;
    public int variable_index;
    public int inactive_flag;
    public int if_clause_primitive_min_index;
    public int if_clause_primitive_max_index;
    public int else_clause_primitive_min_index;
    public int else_clause_primitive_max_index;
    public int default_clause_primitive_min_index;
    public int default_clause_primitive_max_index;
    public int list_size;
    public int[] tokens_list;
    public double[] values_list;
    public boolean is_atomic_independent_variable;
    public int independent_variable_index;

    public Expression(Evaluator new_evaluator, int new_list_size, int[] new_tokens_list, double[] new_values_list) {
        this.evaluator = new_evaluator;
        this.graphics = null;
        this.point_index = -1;
        this.coordinate_index = -1;
        this.variable_index = -1;
        this.inactive_flag = 0;
        this.if_clause_primitive_min_index = -1;
        this.if_clause_primitive_max_index = -1;
        this.else_clause_primitive_min_index = -1;
        this.else_clause_primitive_max_index = -1;
        this.default_clause_primitive_min_index = -1;
        this.default_clause_primitive_max_index = -1;
        this.list_size = new_list_size;
        this.tokens_list = new_tokens_list;
        this.values_list = new_values_list;
        if (2 == this.list_size && 21 == this.tokens_list[0] && this.evaluator.isVariableIndependent((int)this.values_list[0])) {
            this.is_atomic_independent_variable = true;
            this.independent_variable_index = (int)this.values_list[0];
        } else {
            this.is_atomic_independent_variable = false;
            this.independent_variable_index = -1;
        }
    }

    public void setCoordinate(Graphics3D new_graphics, int new_point_index, int new_coordinate_index) {
        this.graphics = new_graphics;
        this.point_index = new_point_index;
        this.coordinate_index = new_coordinate_index;
        this.variable_index = -1;
        this.inactive_flag = 0;
        this.if_clause_primitive_min_index = -1;
        this.if_clause_primitive_max_index = -1;
        this.else_clause_primitive_min_index = -1;
        this.else_clause_primitive_max_index = -1;
        this.default_clause_primitive_min_index = -1;
        this.default_clause_primitive_max_index = -1;
    }

    public void setVariable(int new_variable_index) {
        this.graphics = null;
        this.point_index = -1;
        this.coordinate_index = -1;
        this.variable_index = new_variable_index;
        this.inactive_flag = 0;
        this.if_clause_primitive_min_index = -1;
        this.if_clause_primitive_max_index = -1;
        this.else_clause_primitive_min_index = -1;
        this.else_clause_primitive_max_index = -1;
        this.default_clause_primitive_min_index = -1;
        this.default_clause_primitive_max_index = -1;
    }

    public void setIfCondition(Graphics3D new_graphics, int flag, int if_min_index, int if_max_index, int else_min_index, int else_max_index, int default_min_index, int default_max_index) {
        this.graphics = new_graphics;
        this.point_index = -1;
        this.coordinate_index = -1;
        this.variable_index = -1;
        this.inactive_flag = flag;
        this.if_clause_primitive_min_index = if_min_index;
        this.if_clause_primitive_max_index = if_max_index;
        this.else_clause_primitive_min_index = else_min_index;
        this.else_clause_primitive_max_index = else_max_index;
        this.default_clause_primitive_min_index = default_min_index;
        this.default_clause_primitive_max_index = default_max_index;
    }

    public boolean setValue() {
        if (this.variable_index >= 0) {
            this.evaluator.setVariableValue(this.variable_index, this.current_value);
            return true;
        }
        if (null != this.graphics && this.point_index >= 0 && this.coordinate_index >= 0) {
            return this.graphics.setCoordinateValue(this.point_index, this.coordinate_index, this.current_value);
        }
        if (null != this.graphics && this.inactive_flag > 0) {
            if (1.0 == this.current_value) {
                this.graphics.clearInactiveFlags(this.if_clause_primitive_min_index, this.if_clause_primitive_max_index, this.inactive_flag);
                this.graphics.setInactiveFlags(this.else_clause_primitive_min_index, this.else_clause_primitive_max_index, this.inactive_flag);
                this.graphics.setInactiveFlags(this.default_clause_primitive_min_index, this.default_clause_primitive_max_index, this.inactive_flag);
                return true;
            }
            if (0.0 == this.current_value) {
                this.graphics.setInactiveFlags(this.if_clause_primitive_min_index, this.if_clause_primitive_max_index, this.inactive_flag);
                this.graphics.clearInactiveFlags(this.else_clause_primitive_min_index, this.else_clause_primitive_max_index, this.inactive_flag);
                this.graphics.setInactiveFlags(this.default_clause_primitive_min_index, this.default_clause_primitive_max_index, this.inactive_flag);
                return true;
            }
            this.graphics.setInactiveFlags(this.if_clause_primitive_min_index, this.if_clause_primitive_max_index, this.inactive_flag);
            this.graphics.setInactiveFlags(this.else_clause_primitive_min_index, this.else_clause_primitive_max_index, this.inactive_flag);
            this.graphics.clearInactiveFlags(this.default_clause_primitive_min_index, this.default_clause_primitive_max_index, this.inactive_flag);
            return true;
        }
        return true;
    }

    public void setIndependentVariable(double new_value) {
        if (this.is_atomic_independent_variable) {
            this.current_value = new_value;
            this.evaluator.setVariableValue(this.independent_variable_index, this.current_value);
        }
    }

    public double getCurrentValue() {
        return this.current_value;
    }

    public boolean isAtomicIndependentVariable() {
        return this.is_atomic_independent_variable;
    }

    public boolean evaluate() {
        int token;
        int stack_size = 3;
        boolean arguments_count = false;
        int operators_count = 0;
        boolean function_index = false;
        if (null == this.evaluator) {
            return false;
        }
        double[] stack = this.evaluator.evaluation_stack;
        if (null == stack) {
            return false;
        }
        for (int index = 0; index < this.list_size && 24 != (token = this.tokens_list[index]); ++index) {
            try {
                switch (token) {
                    case 22: {
                        stack[stack_size++] = this.values_list[index];
                        break;
                    }
                    case 27: {
                        break;
                    }
                    case 28: {
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = -first_argument;
                        break;
                    }
                    case 21: {
                        stack[stack_size++] = this.evaluator.getVariableValue((int)this.values_list[index]);
                        break;
                    }
                    case 7: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = first_argument + second_argument;
                        break;
                    }
                    case 8: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = first_argument - second_argument;
                        break;
                    }
                    case 9: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = first_argument * second_argument;
                        break;
                    }
                    case 10: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        if (0.0 == second_argument) {
                            return false;
                        }
                        stack[stack_size++] = first_argument / second_argument;
                        break;
                    }
                    case 11: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = Math.pow(first_argument, second_argument);
                        break;
                    }
                    case 30: {
                        stack_size = this.evaluate_function(stack, stack_size, index);
                        if (stack_size < 0) {
                            return false;
                        }
                        break;
                    }
                    case 34: {
                        double first_argument = stack[--stack_size];
                        if (first_argument == 1.0) {
                            stack[stack_size++] = 0.0;
                            break;
                        }
                        if (first_argument == 0.0) {
                            stack[stack_size++] = 1.0;
                            break;
                        }
                        return false;
                    }
                    case 32: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        if (1.0 == first_argument) {
                            stack[stack_size++] = second_argument;
                            break;
                        }
                        if (1.0 == second_argument) {
                            stack[stack_size++] = first_argument;
                            break;
                        }
                        if (0.0 == first_argument) {
                            stack[stack_size++] = 0.0;
                            break;
                        }
                        if (0.0 == second_argument) {
                            stack[stack_size++] = 0.0;
                            break;
                        }
                        return false;
                    }
                    case 33: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        if (0.0 == first_argument) {
                            stack[stack_size++] = second_argument;
                            break;
                        }
                        if (0.0 == second_argument) {
                            stack[stack_size++] = first_argument;
                            break;
                        }
                        if (1.0 == first_argument) {
                            stack[stack_size++] = 1.0;
                            break;
                        }
                        if (1.0 == second_argument) {
                            stack[stack_size++] = 1.0;
                            break;
                        }
                        return false;
                    }
                    case 12: {
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = this.gamma(first_argument + 1.0);
                        break;
                    }
                    case 13: {
                        double first_argument = stack[--stack_size];
                        if (first_argument <= -2.0) {
                            return false;
                        }
                        stack[stack_size++] = this.factorial2(first_argument);
                        break;
                    }
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 18: 
                    case 19: {
                        stack[stack_size++] = (double)token + 0.5;
                        break;
                    }
                    case 31: {
                        double second_argument;
                        double first_argument;
                        operators_count = (int)this.values_list[index];
                        if (stack_size < 2 * operators_count + 1) {
                            return false;
                        }
                        double result = 1.0;
                        for (int argument_index = 0; argument_index < operators_count; ++argument_index) {
                            int operator_token = (int)stack[stack_size - operators_count + argument_index];
                            first_argument = stack[stack_size - operators_count - argument_index - 2];
                            second_argument = stack[stack_size - operators_count - argument_index - 1];
                            switch (operator_token) {
                                case 14: {
                                    if (first_argument == second_argument) break;
                                    result = 0.0;
                                    break;
                                }
                                case 15: {
                                    if (first_argument != second_argument) break;
                                    result = 0.0;
                                    break;
                                }
                                case 16: {
                                    if (first_argument < second_argument) break;
                                    result = 0.0;
                                    break;
                                }
                                case 18: {
                                    if (first_argument <= second_argument) break;
                                    result = 0.0;
                                    break;
                                }
                                case 17: {
                                    if (first_argument > second_argument) break;
                                    result = 0.0;
                                    break;
                                }
                                case 19: {
                                    if (first_argument >= second_argument) break;
                                    result = 0.0;
                                    break;
                                }
                                default: {
                                    return false;
                                }
                            }
                            if (result < 0.5) break;
                        }
                        stack_size = stack_size - 2 * operators_count - 1;
                        stack[stack_size++] = result;
                        break;
                    }
                    case 35: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = second_argument;
                        break;
                    }
                    case 36: {
                        double second_argument = stack[--stack_size];
                        double first_argument = stack[--stack_size];
                        stack[stack_size++] = second_argument;
                        this.evaluator.setVariableValue((int)this.values_list[index], second_argument);
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            catch (ArithmeticException e) {
                return false;
            }
            if (stack_size > 3) continue;
            return false;
        }
        if (stack_size != 4) {
            return false;
        }
        this.current_value = stack[--stack_size];
        if (Double.isNaN(this.current_value) || Double.isInfinite(this.current_value)) {
            return false;
        }
        return this.setValue();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int evaluate_function(double[] stack, int stack_size, int index) {
        int arguments_count = (int)this.values_list[index] / 1024;
        int function_index = (int)this.values_list[index] & 0x3FF;
        if (stack_size < arguments_count) {
            return -1;
        }
        switch (function_index) {
            case 1: {
                double result = 0.0;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    result += stack[--stack_size];
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 2: {
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                double first_argument = stack[--stack_size];
                stack[stack_size++] = first_argument - second_argument;
                return stack_size;
            }
            case 3: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = -first_argument;
                return stack_size;
            }
            case 4: {
                double result = 1.0;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    result *= stack[--stack_size];
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 5: {
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                double first_argument = stack[--stack_size];
                if (0.0 == second_argument) {
                    return -1;
                }
                stack[stack_size++] = first_argument / second_argument;
                return stack_size;
            }
            case 6: {
                double result = 1.0;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    result = Math.pow(stack[--stack_size], result);
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 7: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.abs(first_argument);
                return stack_size;
            }
            case 8: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                double result = (first_argument = stack[--stack_size]) > 0.0 ? 1.0 : (first_argument < 0.0 ? -1.0 : 0.0);
                stack[stack_size++] = result;
                return stack_size;
            }
            case 9: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((result = Math.floor((first_argument = stack[--stack_size]) + 0.5)) == first_argument + 0.5 && (result > 0.0 && 1 == (1 & (int)result) || result < 0.0 && 1 == (1 & (int)(-result)))) {
                    result -= 1.0;
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 10: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                double result = (first_argument = stack[--stack_size]) >= 0.0 ? Math.floor(first_argument) : Math.ceil(first_argument);
                stack[stack_size++] = result;
                return stack_size;
            }
            case 11: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                double result = (first_argument = stack[--stack_size]) >= 0.0 ? first_argument - Math.floor(first_argument) : first_argument - Math.ceil(first_argument);
                stack[stack_size++] = result;
                return stack_size;
            }
            case 12: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.floor(first_argument);
                return stack_size;
            }
            case 13: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.ceil(first_argument);
                return stack_size;
            }
            case 14: {
                double first_argument;
                double second_argument;
                if (1 == arguments_count) {
                    second_argument = 1.0E-10;
                    first_argument = stack[--stack_size];
                } else {
                    if (2 != arguments_count) return -1;
                    second_argument = stack[--stack_size];
                    first_argument = stack[--stack_size];
                    if (second_argument < 0.0) {
                        return -1;
                    }
                }
                double result = Math.abs(first_argument) < second_argument ? 0.0 : first_argument;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 15: {
                double result = Double.MIN_VALUE;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    if (!(stack[--stack_size] > result)) continue;
                    result = stack[stack_size];
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 16: {
                double result = Double.MAX_VALUE;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    if (!(stack[--stack_size] < result)) continue;
                    result = stack[stack_size];
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 17: 
            case 19: {
                if (arguments_count == 1) return stack_size;
                return -1;
            }
            case 18: {
                if (arguments_count != 1) {
                    return -1;
                }
                stack[stack_size - 1] = 0.0;
                return stack_size;
            }
            case 20: {
                double result;
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) > 0.0) {
                    result = 0.0;
                } else {
                    if (!(first_argument < 0.0)) return -1;
                    result = Math.PI;
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 21: {
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                double first_argument = stack[--stack_size];
                if (0.0 == second_argument) {
                    return -1;
                }
                stack[stack_size++] = first_argument - second_argument * Math.floor(first_argument / second_argument);
                return stack_size;
            }
            case 22: {
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                double first_argument = stack[--stack_size];
                if (0.0 == second_argument) {
                    return -1;
                }
                stack[stack_size++] = Math.floor(first_argument / second_argument);
                return stack_size;
            }
            case 23: {
                if (arguments_count != 0) {
                    return -1;
                }
                double result = Math.random();
                stack[stack_size++] = result;
                return stack_size;
            }
            case 24: {
                if (arguments_count > 1) {
                    return -1;
                }
                if (arguments_count != 1) return stack_size;
                double first_argument = stack[--stack_size];
                return stack_size;
            }
            case 25: {
                double second_argument;
                if (2 == arguments_count) {
                    double second_argument2 = stack[--stack_size];
                    double first_argument = stack[--stack_size];
                    if (0.0 >= second_argument2 || 0.0 > first_argument || 1.0 == first_argument) {
                        return -1;
                    }
                    if (0.0 == first_argument) {
                        stack[stack_size++] = 0.0;
                    }
                    double result = Math.log(second_argument2) / Math.log(first_argument);
                    stack[stack_size++] = result;
                    return stack_size;
                }
                if (1 != arguments_count) return -1;
                if (0.0 >= (second_argument = stack[--stack_size])) {
                    return -1;
                }
                stack[stack_size++] = Math.log(second_argument);
                return stack_size;
            }
            case 26: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.exp(first_argument);
                return stack_size;
            }
            case 27: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 > (first_argument = stack[--stack_size])) {
                    return -1;
                }
                stack[stack_size++] = Math.sqrt(first_argument);
                return stack_size;
            }
            case 28: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.sin(first_argument);
                return stack_size;
            }
            case 29: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.cos(first_argument);
                return stack_size;
            }
            case 30: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.tan(first_argument);
                return stack_size;
            }
            case 31: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.sin(first_argument = stack[--stack_size]))) {
                    return -1;
                }
                stack[stack_size++] = 1.0 / result;
                return stack_size;
            }
            case 32: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.cos(first_argument = stack[--stack_size]))) {
                    return -1;
                }
                stack[stack_size++] = 1.0 / result;
                return stack_size;
            }
            case 33: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.tan(first_argument = stack[--stack_size]))) {
                    return -1;
                }
                stack[stack_size++] = 1.0 / result;
                return stack_size;
            }
            case 34: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) > 1.0 || first_argument < -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.asin(first_argument);
                return stack_size;
            }
            case 35: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) > 1.0 || first_argument < -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.acos(first_argument);
                return stack_size;
            }
            case 36: {
                if (1 == arguments_count) {
                    double first_argument = stack[--stack_size];
                    stack[stack_size++] = Math.atan(first_argument);
                    return stack_size;
                }
                if (2 != arguments_count) return -1;
                double second_argument = stack[--stack_size];
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.atan2(second_argument, first_argument);
                return stack_size;
            }
            case 37: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (first_argument = stack[--stack_size])) {
                    return -1;
                }
                double result = 1.0 / first_argument;
                if (result > 1.0 || result < -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.asin(result);
                return stack_size;
            }
            case 38: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (first_argument = stack[--stack_size])) {
                    return -1;
                }
                double result = 1.0 / first_argument;
                if (result > 1.0 || result < -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.acos(result);
                return stack_size;
            }
            case 39: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (first_argument = stack[--stack_size])) {
                    return -1;
                }
                double result = 1.0 / first_argument;
                stack[stack_size++] = Math.atan(result);
                return stack_size;
            }
            case 40: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = (Math.exp(first_argument) - Math.exp(-first_argument)) / 2.0;
                return stack_size;
            }
            case 41: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = (Math.exp(first_argument) + Math.exp(-first_argument)) / 2.0;
                return stack_size;
            }
            case 42: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.exp(first_argument = stack[--stack_size]) + Math.exp(-first_argument))) {
                    return -1;
                }
                stack[stack_size++] = (Math.exp(first_argument) - Math.exp(-first_argument)) / result;
                return stack_size;
            }
            case 43: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.exp(first_argument = stack[--stack_size]) - Math.exp(-first_argument))) {
                    return -1;
                }
                stack[stack_size++] = 1.0 / result;
                return stack_size;
            }
            case 44: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.exp(first_argument = stack[--stack_size]) + Math.exp(-first_argument))) {
                    return -1;
                }
                stack[stack_size++] = 1.0 / result;
                return stack_size;
            }
            case 45: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (result = Math.exp(first_argument = stack[--stack_size]) - Math.exp(-first_argument))) {
                    return -1;
                }
                stack[stack_size++] = (Math.exp(first_argument) + Math.exp(-first_argument)) / result;
                return stack_size;
            }
            case 46: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = Math.log(first_argument + Math.sqrt(1.0 + first_argument * first_argument));
                return stack_size;
            }
            case 47: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 > (result = (first_argument = stack[--stack_size]) * first_argument - 1.0)) {
                    return -1;
                }
                stack[stack_size++] = Math.log(first_argument + Math.sqrt(result));
                return stack_size;
            }
            case 48: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (1.0 - (first_argument = stack[--stack_size]) <= 0.0 || -1.0 >= first_argument) {
                    return -1;
                }
                double result = (1.0 + first_argument) / (1.0 - first_argument);
                if (result <= 0.0) {
                    return -1;
                }
                stack[stack_size++] = Math.log(Math.sqrt(result));
                return stack_size;
            }
            case 49: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (0.0 == (first_argument = stack[--stack_size])) {
                    return -1;
                }
                double result = first_argument < 0.0 ? Math.log((1.0 - Math.sqrt(1.0 + first_argument * first_argument)) / first_argument) : Math.log((1.0 + Math.sqrt(1.0 + first_argument * first_argument)) / first_argument);
                stack[stack_size++] = result;
                return stack_size;
            }
            case 50: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((result = 1.0 - (first_argument = stack[--stack_size]) * first_argument) < 0.0 || first_argument <= 0.0) {
                    return -1;
                }
                stack[stack_size++] = Math.log((1.0 + Math.sqrt(result)) / first_argument);
                return stack_size;
            }
            case 51: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if (1.0 - (first_argument = stack[--stack_size]) == 0.0) {
                    return -1;
                }
                double result = (-1.0 - first_argument) / (1.0 - first_argument);
                if (result <= 0.0) {
                    return -1;
                }
                stack[stack_size++] = Math.log(Math.sqrt(result));
                return stack_size;
            }
            case 52: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) <= -1.0) {
                    return -1;
                }
                stack[stack_size++] = this.gamma(first_argument + 1.0);
                return stack_size;
            }
            case 53: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = this.factorial2(first_argument);
                return stack_size;
            }
            case 54: {
                double first_argument;
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                if ((first_argument = stack[--stack_size]) <= -1.0 || second_argument <= -1.0 || first_argument - second_argument <= -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.exp(this.logGamma(first_argument + 1.0) - this.logGamma(second_argument + 1.0) - this.logGamma(first_argument - second_argument + 1.0));
                return stack_size;
            }
            case 55: {
                if (arguments_count < 0) {
                    return -1;
                }
                double result = 0.0;
                double second_argument = 0.0;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    double first_argument;
                    if ((first_argument = stack[--stack_size]) <= -1.0) {
                        return -1;
                    }
                    second_argument += first_argument;
                    result += this.logGamma(first_argument + 1.0);
                }
                if (result <= -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.exp(this.logGamma(second_argument + 1.0) - result);
                return stack_size;
            }
            case 56: {
                double second_argument;
                double first_argument;
                if (arguments_count != 2) {
                    return -1;
                }
                --stack_size;
                if ((first_argument = stack[--stack_size]) + (second_argument = stack[stack_size]) <= -1.0 || second_argument <= -1.0) {
                    return -1;
                }
                stack[stack_size++] = Math.exp(this.logGamma(first_argument + second_argument + 1.0) - this.logGamma(second_argument + 1.0));
                return stack_size;
            }
            case 57: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = this.gamma(first_argument);
                return stack_size;
            }
            case 58: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = this.logGamma(first_argument);
                return stack_size;
            }
            case 112: {
                double second_argument;
                double first_argument;
                double result;
                if (arguments_count != 2) {
                    return -1;
                }
                --stack_size;
                if (0.0 == (result = this.gamma((first_argument = stack[--stack_size]) + (second_argument = stack[stack_size])))) {
                    return -1;
                }
                stack[stack_size++] = this.gamma(first_argument) * this.gamma(second_argument) / result;
                return stack_size;
            }
            case 59: {
                if (arguments_count != 3) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                double result = stack[--stack_size];
                double first_argument = stack[--stack_size];
                if (0.0 == second_argument || 0.0 > result) {
                    return -1;
                }
                first_argument = Math.pow(first_argument, result);
                stack[stack_size++] = first_argument - second_argument * Math.floor(first_argument / second_argument);
                return stack_size;
            }
            case 60: {
                if (arguments_count == 2) {
                    double second_argument = stack[--stack_size];
                    double first_argument = stack[--stack_size];
                    stack[stack_size++] = this.erf(second_argument) - this.erf(first_argument);
                    return stack_size;
                }
                if (arguments_count != 1) return -1;
                double first_argument = stack[--stack_size];
                stack[stack_size++] = this.erf(first_argument);
                return stack_size;
            }
            case 61: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = 1.0 - this.erf(first_argument);
                return stack_size;
            }
            case 62: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = this.erfi(first_argument);
                return stack_size;
            }
            case 63: {
                double first_argument;
                double second_argument;
                if (1 == arguments_count) {
                    second_argument = 1.0E-4;
                    first_argument = stack[--stack_size];
                } else {
                    if (2 != arguments_count) return -1;
                    second_argument = stack[--stack_size];
                    first_argument = stack[--stack_size];
                    if (second_argument < 0.0) {
                        return -1;
                    }
                }
                first_argument = stack[--stack_size];
                double result = Math.floor(first_argument * 12600.0 + 0.5);
                if (Math.abs(result - first_argument) < second_argument * 10.0) {
                    result = first_argument;
                }
                stack[stack_size++] = result;
                return stack_size;
            }
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 69: {
                if (stack_size < arguments_count) {
                    return -1;
                }
                double result = 1.0;
                for (int argument_index = 0; argument_index < arguments_count - 1; ++argument_index) {
                    double first_argument = stack[stack_size - argument_index - 2];
                    double second_argument = stack[stack_size - argument_index - 1];
                    switch (function_index) {
                        case 64: {
                            if (first_argument == second_argument) break;
                            result = 0.0;
                            break;
                        }
                        case 65: {
                            if (first_argument != second_argument) break;
                            result = 0.0;
                            break;
                        }
                        case 66: {
                            if (first_argument < second_argument) break;
                            result = 0.0;
                            break;
                        }
                        case 68: {
                            if (first_argument <= second_argument) break;
                            result = 0.0;
                            break;
                        }
                        case 67: {
                            if (first_argument > second_argument) break;
                            result = 0.0;
                            break;
                        }
                        case 69: {
                            if (first_argument >= second_argument) break;
                            result = 0.0;
                            break;
                        }
                        default: {
                            return -1;
                        }
                    }
                    if (result < 0.5) break;
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 70: 
            case 71: 
            case 80: {
                if (arguments_count != 1) {
                    return -1;
                }
                double first_argument = stack[--stack_size];
                stack[stack_size++] = 1.0;
                return stack_size;
            }
            case 72: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) == Math.floor(first_argument + 0.5)) {
                    stack[stack_size++] = 1.0;
                    return stack_size;
                }
                stack[stack_size++] = 0.0;
                return stack_size;
            }
            case 73: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((result = Math.floor((first_argument = stack[--stack_size]) + 0.5)) != first_argument || result != Math.floor(result / 2.0 + 0.5)) {
                    stack[stack_size++] = 0.0;
                    return stack_size;
                }
                stack[stack_size++] = 1.0;
                return stack_size;
            }
            case 74: {
                double first_argument;
                double result;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((result = Math.floor((first_argument = stack[--stack_size]) + 0.5)) != first_argument || result == Math.floor(result / 2.0 + 0.5)) {
                    stack[stack_size++] = 0.0;
                    return stack_size;
                }
                stack[stack_size++] = 1.0;
                return stack_size;
            }
            case 75: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) > 0.0) {
                    stack[stack_size++] = 1.0;
                    return stack_size;
                }
                stack[stack_size++] = 0.0;
                return stack_size;
            }
            case 76: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) < 0.0) {
                    stack[stack_size++] = 1.0;
                    return stack_size;
                }
                stack[stack_size++] = 0.0;
                return stack_size;
            }
            case 77: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) <= 0.0) {
                    stack[stack_size++] = 1.0;
                    return stack_size;
                }
                stack[stack_size++] = 0.0;
                return stack_size;
            }
            case 78: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) >= 0.0) {
                    stack[stack_size++] = 1.0;
                    return stack_size;
                }
                stack[stack_size++] = 0.0;
                return stack_size;
            }
            case 79: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) == 1.0) {
                    stack[stack_size++] = 1.0;
                    return stack_size;
                }
                stack[stack_size++] = 0.0;
                return stack_size;
            }
            case 81: {
                double first_argument;
                if (arguments_count != 1) {
                    return -1;
                }
                if ((first_argument = stack[--stack_size]) == 1.0) {
                    stack[stack_size++] = 0.0;
                    return stack_size;
                }
                if (first_argument != 0.0) return -1;
                stack[stack_size++] = 1.0;
                return stack_size;
            }
            case 85: {
                double first_argument;
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                if (1.0 == (first_argument = stack[--stack_size])) {
                    stack[stack_size++] = second_argument;
                    return stack_size;
                }
                if (0.0 != first_argument) return -1;
                stack[stack_size++] = 1.0;
                return stack_size;
            }
            case 82: 
            case 83: 
            case 84: {
                if (stack_size < arguments_count) {
                    return -1;
                }
                double result = 82 == function_index ? 1.0 : 0.0;
                block109: for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    double first_argument = stack[stack_size - argument_index - 1];
                    switch (function_index) {
                        case 82: {
                            if (0.0 == first_argument) {
                                result = 0.0;
                                continue block109;
                            }
                            if (1.0 == first_argument) continue block109;
                            return -1;
                        }
                        case 83: {
                            if (1.0 == first_argument) {
                                result = 1.0;
                                continue block109;
                            }
                            if (0.0 == first_argument) continue block109;
                            return -1;
                        }
                        case 84: {
                            if (1.0 == first_argument) {
                                result = 1.0 - result;
                                continue block109;
                            }
                            if (0.0 == first_argument) continue block109;
                            return -1;
                        }
                        default: {
                            return -1;
                        }
                    }
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 86: {
                double result;
                if (arguments_count < 2 || arguments_count > 4) {
                    return -1;
                }
                double first_argument = stack[stack_size - arguments_count];
                if (1.0 == first_argument) {
                    result = stack[stack_size - arguments_count + 1];
                } else if (0.0 == first_argument) {
                    if (arguments_count <= 2) return -1;
                    result = stack[stack_size - arguments_count + 2];
                } else {
                    if (arguments_count <= 3) return -1;
                    result = stack[stack_size - arguments_count + 3];
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 87: {
                int argument_index;
                if ((arguments_count & 1) == 1) {
                    return -1;
                }
                double result = 0.0;
                for (argument_index = 0; argument_index < arguments_count; argument_index += 2) {
                    double second_argument = stack[stack_size - arguments_count + 1 + argument_index];
                    double first_argument = stack[stack_size - arguments_count + argument_index];
                    if (1.0 == first_argument) {
                        result = second_argument;
                        break;
                    }
                    if (0.0 == first_argument) continue;
                    return -1;
                }
                if (argument_index >= arguments_count) {
                    return -1;
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 88: {
                int argument_index;
                if ((arguments_count & 1) == 0) {
                    return -1;
                }
                double result = stack[stack_size - arguments_count];
                for (argument_index = 0; argument_index < arguments_count - 1; argument_index += 2) {
                    double second_argument = stack[stack_size - arguments_count + 2 + argument_index];
                    double first_argument = stack[stack_size - arguments_count + 1 + argument_index];
                    if (result != first_argument) continue;
                    result = second_argument;
                    break;
                }
                if (argument_index >= arguments_count - 1) {
                    return -1;
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 89: 
            case 90: 
            case 91: 
            case 92: 
            case 93: 
            case 94: 
            case 100: 
            case 101: 
            case 102: 
            case 103: 
            case 104: 
            case 105: {
                if (arguments_count == 1) return stack_size;
                return -1;
            }
            case 95: 
            case 96: 
            case 97: 
            case 99: {
                double first_argument;
                if (1 == arguments_count) {
                    first_argument = stack[--stack_size];
                } else {
                    if (2 != arguments_count) return -1;
                    double second_argument = stack[--stack_size];
                    first_argument = stack[--stack_size];
                }
                stack[stack_size++] = first_argument;
                return stack_size;
            }
            case 106: 
            case 107: {
                if (arguments_count != 0) {
                    return -1;
                }
                double result = (double)System.currentTimeMillis() / 1000.0;
                stack[stack_size++] = result - this.evaluator.seconds_since_1970;
                return stack_size;
            }
            case 108: {
                if (arguments_count != 0) {
                    return -1;
                }
                stack[stack_size++] = -2.085978496E9 + (double)System.currentTimeMillis() / 1000.0;
                return stack_size;
            }
            case 109: {
                if (stack_size < arguments_count) {
                    return -1;
                }
                double result = 1.0;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    double first_argument = stack[stack_size - argument_index - 1];
                    if (0.0 == first_argument) continue;
                    result = 0.0;
                    break;
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 110: {
                if (stack_size < arguments_count) {
                    return -1;
                }
                double result = 1.0;
                double first_argument = stack[stack_size - 1];
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    double second_argument = stack[stack_size - argument_index - 1];
                    if (second_argument == first_argument) continue;
                    result = 0.0;
                    break;
                }
                if (1 == arguments_count && first_argument != 0.0) {
                    result = 0.0;
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 111: {
                if (stack_size < arguments_count) {
                    return -1;
                }
                double result = 1.0;
                for (int argument_index = 0; argument_index < arguments_count; ++argument_index) {
                    double first_argument = stack[stack_size - argument_index - 1];
                    if (!(first_argument < 0.0)) continue;
                    result = 0.0;
                    break;
                }
                stack_size -= arguments_count;
                stack[stack_size++] = result;
                return stack_size;
            }
            case 113: {
                if (arguments_count != 2) {
                    return -1;
                }
                double second_argument = stack[--stack_size];
                double first_argument = stack[--stack_size];
                stack[stack_size++] = second_argument;
                this.evaluator.setVariableValue((int)first_argument, second_argument);
                return stack_size;
            }
            default: {
                return -1;
            }
        }
    }

    public void resetValue() {
        this.current_value = this.last_valid_value;
        this.setValue();
    }

    public void confirmValue() {
        this.last_valid_value = this.current_value;
    }

    public double erf(double x) {
        double x2 = x * x;
        if (x2 < 0.417316) {
            return x * (1.1283791670955126 + x2 * (-0.37612638903183754 + x2 * (0.11283791670955126 + x2 * (-0.026866170645131252 + x2 * (0.005223977625442188 + x2 * (-8.548327023450853E-4 + x2 * 1.2055332981789664E-4))))));
        }
        return (x > 0.0 ? 1.0 : -1.0) - 0.5641895835477563 / x * Math.exp(-x2) * (1.0 + 1.0 / (-0.9995450369403409 + x * (-1.775762362302549 + x * (-1.131190748119284 + x * (-0.2693430703319502 + x * (0.04984841389825107 + x * (-0.003959278415228862 + x * -9.749847083947127E-5)))))));
    }

    public double erfi(double x) {
        double x2 = x * x;
        if (x2 < 3.7558439999999997) {
            return x * (1.1283791670955126 + x2 * (0.37612638903183754 + x2 * (0.11283791670955126 + x2 * (0.026866170645131252 + x2 * (0.005223977625442188 + x2 * (8.548327023450853E-4 + x2 * (1.2055332981789664E-4 + x2 * (1.492565035840625E-5 + x2 * 1.6462114365889248E-6))))))));
        }
        return (x > 0.0 ? 1.0 : -1.0) + 0.5641895835477563 / x * Math.exp(x2) * (1.0 + 0.5 / x2);
    }

    public double gamma(double x) {
        if (x < 0.999999) {
            double y = Math.sin(Math.PI * (1.0 - x));
            if (0.0 == y) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.PI * (1.0 - x) / this.gamma(2.0 - x) / y;
        }
        double y = x - 0.5 + 0.5772156649015329;
        double series = -0.033065598370407914 + x * (7.675315151147096 + x * (0.17079593808620658 + x * (-0.053762067160213846 + x * (0.010456709616406415 + x * (-0.0012260922213384849 + x * (7.933850210667055E-5 + x * -2.1735396138730348E-6))))));
        if (series <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return Math.pow(y, x - 0.5) * Math.exp(-y) * 2.5066282746310007 * (1.0 + 1.0 / series);
    }

    public double logGamma(double x) {
        if (x < 0.999999) {
            double y = Math.sin(Math.PI * (1.0 - x));
            if (y <= 0.0) {
                return Double.POSITIVE_INFINITY;
            }
            return Math.log(Math.PI * (1.0 - x) / y) - this.logGamma(2.0 - x);
        }
        double y = x - 0.5 + 0.5772156649015329;
        double series = -0.033065598370407914 + x * (7.675315151147096 + x * (0.17079593808620658 + x * (-0.053762067160213846 + x * (0.010456709616406415 + x * (-0.0012260922213384849 + x * (7.933850210667055E-5 + x * -2.1735396138730348E-6))))));
        if (series <= 0.0) {
            return Double.POSITIVE_INFINITY;
        }
        return (x - 0.5) * Math.log(y) - y + 0.9189385332046728 + Math.log(1.0 + 1.0 / series);
    }

    double factorial2(double x) {
        return Math.pow(2.0, x / 2.0) * Math.pow(0.6366197723675814, 0.25 * (1.0 - Math.cos(Math.PI * x)) * this.gamma(1.0 + x / 2.0));
    }
}

