% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/volnmf_estimate.R
\name{volnmf_main}
\alias{volnmf_main}
\title{Volume-regularized NMF}
\usage{
volnmf_main(
  vol,
  B = NULL,
  volnmf = NULL,
  n.comp = 3,
  n.reduce = n.comp,
  do.nmf = TRUE,
  iter.nmf = 100,
  seed = NULL,
  domain = "covariance",
  volf = "logdet",
  wvol = NULL,
  delta = 1e-08,
  n.iter = 500,
  err.cut = 1e-16,
  vol.iter = 20,
  c.iter = 20,
  extrapolate = TRUE,
  accelerate = FALSE,
  acc.C = 4/5,
  acc.R = 3/4,
  C.constraint = "col",
  C.bound = 1,
  R.constraint = "pos",
  R.majorate = FALSE,
  C.init = NULL,
  R.init = NULL,
  Q.init = NULL,
  anchor = NULL,
  Ctrue = NULL,
  verbose = TRUE,
  record = 100,
  verbose.nmf = FALSE,
  record.nmf = NULL,
  mutation.run = FALSE
)
}
\arguments{
\item{vol}{An output object of vol_preprocess().}

\item{B}{A numeric matrix. A matrix to factorize (by default NULL). If not given than matrix \code{B} is taken to be a square root decomposition of \eqn{P = B*t(B)}.}

\item{volnmf}{An output object of \code{volnmf.main}. An option is useful to re-estimate solution using different parameters (by default NULL).}

\item{n.comp}{An integer. Number of components to extract (by default 3). Defines number of columns in matrix \eqn{C}.}

\item{n.reduce}{An integer. Dimensional reduction of matrix B (number of columns) if taken as a square root decomposition of \code{volP} (by default equal to \code{n.comp}).}

\item{do.nmf}{A boolean. Estimate standard solution with \code{w.vol=0} as initialization before applying volume regularization (by default \code{TRUE}).}

\item{iter.nmf}{An integer. Number of iterations to get solution with \code{w.vol=0} if the former requested (by default \code{1,000}).}

\item{seed}{An integer. Fix seed.}

\item{domain}{A character. Optimize unitary rotation matrix \code{Q} ("covariance") or keep it as identity matrix (as in standard NMF). By default "covariance".}

\item{volf}{A character. Function that approximate volume. Can have values of "logdet" or "det" (by default "logdet").}

\item{wvol}{A numeric. A weight of volume-regularized term \code{volume(R)}.}

\item{delta}{A numeric. Logdet regularization term \code{log(det(R) + delta)} (by default 1e-8).}

\item{n.iter}{An integer. Number of iterations (by default \code{1,000}).}

\item{err.cut}{A numeric. Relative error in determinant between iterations to stop algorithm (by default \code{1e-8}).}

\item{vol.iter}{An integer. Number of iterations to update volume-regularized matrix \code{R} at each alternating step.}

\item{c.iter}{An integer. Number of iterations to update simplex matrix \code{C} at each alternating step.}

\item{extrapolate}{A numeric. Do Nesterov extrapolation inside blocks of R and C optimization (by default TRUE).}

\item{accelerate}{A numeric. Do acceleration each update after R and C blocks estimated via Nesterov-like extrapolation.}

\item{acc.C}{A numeric. Acceleration parameter of matrix C.}

\item{acc.R}{A numeric. Acceleration parameter of matrix R.}

\item{C.constraint}{A character. Constraint either sum of columns ("col") or sum of rows ("row) to be equal to \code{C.bound} (By default "col").}

\item{C.bound}{A numeric. A simplex constraint on matrix C vectors.}

\item{R.constraint}{A character. Set up non-negativity ("pos") constraint on elements of \code{R} (by default "pos", alternative "no").}

\item{R.majorate}{A boolean. Majorate logdet each iteration of \code{volnmf_logdet()} (by default FALSE).}

\item{C.init}{Numeric matrices. Initialization of matrices \code{C, R, Q} (by default \code{NULL}).}

\item{R.init}{Numeric matrices. Initialization of matrices \code{C, R, Q} (by default \code{NULL}).}

\item{Q.init}{Numeric matrices. Initialization of matrices \code{C, R, Q} (by default \code{NULL}).}

\item{anchor}{An output object of \code{AnchorFree()}. Object is used optionally to initialize matrices (by default \code{NULL}).}

\item{Ctrue}{A matrix. Correct matrix C if known. Useful for benchmark.}

\item{verbose}{A boolean. Print per-iteration information (by default FALSE).}

\item{record}{A numeric. Record parameters every 'record' iterations (by default \code{NULL}).}

\item{verbose.nmf}{A boolean. Print per-iteration information for standard NMF (by default FALSE).}

\item{record.nmf}{A numeric. Record parameters every 'record' iterations for standard NMF (by default \code{NULL}).}

\item{mutation.run}{A boolean. Assess goodness of solution using reflection test if mutation.run=TRUE (applicable only to analysis of mutation patterns).}
}
\value{
List of objects:

\code{C, R, Q} Factorization matrices.

\code{C.init, R.init, Q.init} Initialization matrices for volume-regularized optimization.

\code{C.rand, R.rand, Q.rand} Random initialization matrices for NMF optimization \code{(w.vol=0)}.

\code{rec} a list of objects that record and store state of matrices each \code{record} iterations.
}
\description{
\code{volnmf_main} enables volume-regularized factorization of a matrix \code{B} using the following objective function:
\eqn{F = ||B*Q - C*R||^2 + w.vol*volume(R)}. Matrix \code{C} is required to be non-negative and having either column or row vectors on the simplex.
Matrix \code{R} can optionally have non-negativity constraint. Matrix \code{Q} can optionally be identity matrix or any unitary.
The latter option is used to decompose co-occurence matrix \code{vol_P}.
}
