% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rquery_treatment.R
\name{as_rquery_plan}
\alias{as_rquery_plan}
\title{Convert vtreatment plans into a sequence of rquery read operations.}
\usage{
as_rquery_plan(treatmentplans, ..., var_restriction = NULL)
}
\arguments{
\item{treatmentplans}{vtreat treatment plan or list of vtreat treatment plan sharing same outcome and outcome type.}

\item{...}{not used, force any later arguments to bind to names.}

\item{var_restriction}{character, if not null restrict to producing these variables.}
}
\value{
list(optree_generator (ordered list of functions), temp_tables (named list of tables))
}
\description{
Convert vtreatment plans into a sequence of rquery read operations.
}
\examples{

if(requireNamespace("rquery", quietly = TRUE)) {
   dTrainC <- data.frame(x= c('a', 'a', 'a', 'b' ,NA , 'b'),
                         z= c(1, 2, NA, 4, 5, 6),
                         y= c(FALSE, FALSE, TRUE, FALSE, TRUE, TRUE),
                         stringsAsFactors = FALSE)
   dTrainC$id <- seq_len(nrow(dTrainC))
   treatmentsC <- designTreatmentsC(dTrainC, c("x", "z"), 'y', TRUE)
   print(prepare(treatmentsC, dTrainC))
   rqplan <- as_rquery_plan(list(treatmentsC))
   ops <- flatten_fn_list(rquery::local_td(dTrainC), rqplan$optree_generators)
   cat(format(ops))
   if(requireNamespace("rqdatatable", quietly = TRUE)) {
      treated <- rqdatatable::ex_data_table(ops, tables = rqplan$tables)
      print(treated[])
   }
   if(requireNamespace("DBI", quietly = TRUE) &&
      requireNamespace("RSQLite", quietly = TRUE)) {
      db <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
      source_data <- rquery::rq_copy_to(db, "dTrainC", dTrainC,
                               overwrite = TRUE, temporary = TRUE)

      rest <- materialize_treated(db, rqplan, source_data, "dTreatedC", 
                                  extracols = "id",
                                  print_sql = FALSE)
      resd <- DBI::dbReadTable(db, rest$table_name)
      print(resd)

      rquery::rq_remove_table(db, source_data$table_name)
      rquery::rq_remove_table(db, rest$table_name)
      DBI::dbDisconnect(db)
   }
}

}
\seealso{
\code{\link{materialize_treated}}
}
