% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hostess.R
\name{hostess}
\alias{hostess}
\alias{use_hostess}
\alias{hostess_init}
\alias{hostess_set}
\alias{Hostess}
\title{Hostess}
\usage{
use_hostess()

hostess_init(id = "hostess")

hostess_set(id = "hostess", value)
}
\arguments{
\item{id}{Id of hostess (valid CSS).}

\item{value}{Value to set, between \code{0} and \code{100}.}
}
\description{
Add hostess dependencies.
}
\examples{

## ------------------------------------------------
## Method `Hostess$new`
## ------------------------------------------------

\dontrun{Hostess$new()}

## ------------------------------------------------
## Method `Hostess$set`
## ------------------------------------------------

\dontrun{Hostess$new()$set(20)}

## ------------------------------------------------
## Method `Hostess$inc`
## ------------------------------------------------

\dontrun{Hostess$new()$inc(10)}

## ------------------------------------------------
## Method `Hostess$get_loader`
## ------------------------------------------------

\dontrun{Hostess$new()$get_loader()}

## ------------------------------------------------
## Method `Hostess$set_loader`
## ------------------------------------------------

\dontrun{
loader <- hostess_loader()
Hostess$new()$set_loader(loader)
}

## ------------------------------------------------
## Method `Hostess$notify`
## ------------------------------------------------

\dontrun{Hostess$new()$notify()}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{Hostess$new()}}
\item \href{#method-start}{\code{Hostess$start()}}
\item \href{#method-print}{\code{Hostess$print()}}
\item \href{#method-set}{\code{Hostess$set()}}
\item \href{#method-inc}{\code{Hostess$inc()}}
\item \href{#method-get_loader}{\code{Hostess$get_loader()}}
\item \href{#method-set_loader}{\code{Hostess$set_loader()}}
\item \href{#method-notify}{\code{Hostess$notify()}}
\item \href{#method-clone}{\code{Hostess$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$new(id = NULL, min = 0, max = 100, n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{Id used in \code{hostess_loader} if you generate the loader with
the \code{loader} method you may leave this \code{NULL}.}

\item{\code{min, max}}{Minimum and maximum representing the starting and ending
points of the progress bar.}

\item{\code{n}}{Number of loaders to generate.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a hostess.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Hostess$new()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-start"></a>}}
\if{latex}{\out{\hypertarget{method-start}{}}}
\subsection{Method \code{start()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$start()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Start the hostess
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$print()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Print the hostess
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set"></a>}}
\if{latex}{\out{\hypertarget{method-set}{}}}
\subsection{Method \code{set()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$set(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to set, between \code{0} and \code{100}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set the hostess loading bar.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Hostess$new()$set(20)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-inc"></a>}}
\if{latex}{\out{\hypertarget{method-inc}{}}}
\subsection{Method \code{inc()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$inc(value)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{value}}{Value to set, between \code{0} and \code{100}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Increase the hostess loading bar.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Hostess$new()$inc(10)}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-get_loader"></a>}}
\if{latex}{\out{\hypertarget{method-get_loader}{}}}
\subsection{Method \code{get_loader()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$get_loader(
  preset = NULL,
  text_color = "#FFFFFF",
  center_page = FALSE,
  class = "",
  min = NULL,
  max = NULL,
  svg = NULL,
  progress_type = c("stroke", "fill"),
  fill_direction = c("btt", "ttb", "ltr", "rtl"),
  stroke_direction = c("normal", "reverse"),
  fill_color = NULL,
  stroke_color = NULL,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{preset}}{A loading bar preset, see section below.}

\item{\code{text_color}}{The color of the loading text.}

\item{\code{center_page}}{By default the hostess is centered in the middle
of the screen, ideal when using it with waiter full screen, set to
\code{FALSE} to prevent that.}

\item{\code{class}}{CSS class.}

\item{\code{min, max}}{Minimum and maximum representing the starting and ending
points of the progress bar.}

\item{\code{svg}}{Either an svg path e.g.: \code{M10 10L90 10} or the path to a \code{.svg}
file. Note that if passing the latter it must be made available to Shiny by
placing it either in the \code{www} folder or using \code{\link[shiny:resourcePaths]{shiny::addResourcePath()}}.}

\item{\code{progress_type}}{The progress type, either \code{stroke} or \code{fill}.
Ther former traces the path of the \code{svg} while the latter fills it progressively.}

\item{\code{fill_direction, stroke_direction}}{The direction which the progress bar should
take. Wether \code{fill_direction} or \code{stroke_direction} is used depends on
\code{progress_type}.}

\item{\code{fill_color, stroke_color}}{The color to use for the progress bar.
Wether \code{fill_color} or \code{stroke_color} is used depends on
\code{progress_type}.}

\item{\code{...}}{Any other other advanced options to pass to the loaded
see the \href{https://loading.io/progress/}{official documentation}.}

\item{\code{value}}{Value to set, between \code{0} and \code{100}.}

\item{\code{with_waiter}}{Deprecate in favour of \code{center_page}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a hostess loading bar.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Hostess$new()$get_loader()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_loader"></a>}}
\if{latex}{\out{\hypertarget{method-set_loader}{}}}
\subsection{Method \code{set_loader()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$set_loader(loader)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{loader}}{Loader as defined by \code{\link[=hostess_loader]{hostess_loader()}}.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set a hostess loader as defined by \code{\link[=hostess_loader]{hostess_loader()}}.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{
loader <- hostess_loader()
Hostess$new()$set_loader(loader)
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-notify"></a>}}
\if{latex}{\out{\hypertarget{method-notify}{}}}
\subsection{Method \code{notify()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$notify(
  html = NULL,
  background_color = "transparent",
  text_color = "black",
  position = c("br", "tr", "bl", "tl")
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{html}}{Additional HTML content of the tag or a character string.}

\item{\code{background_color}}{Background color of the notification.}

\item{\code{text_color}}{Color of text of \code{html}.}

\item{\code{position}}{Position of the notification on the screen.
Where \code{br} is the bottom-right, \code{tr} is the top-right,
\code{bl} is bottom-left, and \code{tl} is the top-left.}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Use the hostess as a notification. It is hidden when \code{set} tpo \code{100}.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{\dontrun{Hostess$new()$notify()}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Hostess$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
