% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/education.R
\name{education}
\alias{education}
\title{Generate Random Vector of Educational Attainment Level}
\usage{
education(n, x = c("No Schooling Completed", "Nursery School to 8th Grade",
  "9th Grade to 12th Grade, No Diploma", "Regular High School Diploma",
  "GED or Alternative Credential", "Some College, Less than 1 Year",
  "Some College, 1 or More Years, No Degree", "Associate's Degree",
  "Bachelor's Degree", "Master's Degree", "Professional School Degree",
  "Doctorate Degree"), prob = c(0.013, 0.05, 0.085, 0.246, 0.039, 0.064, 0.15,
  0.075, 0.176, 0.072, 0.019, 0.012), name = "Education")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of educational attainment level elements.
}
\description{
Generate a random vector of educational attainment level.
}
\details{
The educational attainments and probabilities used match approximate
U.S. educational attainment make-up (http://www.census.gov):

\tabular{lr}{
  \bold{ Highest Attainment}        \tab \bold{Percent} \cr
  No Schooling Completed                   \tab 1.3 \% \cr
  Nursery School to 8th Grade              \tab 5 \%   \cr
  9th Grade to 12th Grade, No Diploma      \tab 8.5 \% \cr
  Regular High School Diploma              \tab 24.6 \%\cr
  GED or Alternative Credential            \tab 3.9 \% \cr
  Some College, Less than 1 Year           \tab 6.4 \% \cr
  Some College, 1 or More Years, No Degree \tab 15 \%  \cr
  Associate's Degree                       \tab 7.5 \% \cr
  Bachelor's Degree                        \tab 17.6 \%\cr
  Master's Degree                          \tab 7.2 \% \cr
  Professional School Degree               \tab 1.9 \% \cr
  Doctorate Degree                         \tab 1.2 \% \cr
}
}
\examples{
education(10)
pie(table(education(10000)))
}
\references{
http://www.census.gov
}
\seealso{
Other variable.functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{employment}},
  \code{\link{eye}}, \code{\link{grade_level}},
  \code{\link{grade}}, \code{\link{group}},
  \code{\link{hair}}, \code{\link{height}},
  \code{\link{income}}, \code{\link{internet_browser}},
  \code{\link{iq}}, \code{\link{language}},
  \code{\link{level}}, \code{\link{likert}},
  \code{\link{lorem_ipsum}}, \code{\link{marital}},
  \code{\link{military}}, \code{\link{month}},
  \code{\link{name}}, \code{\link{normal}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{education}

