% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/walkr-package.R, R/walkr.R
\docType{package}
\name{walkr}
\alias{walkr}
\alias{walkr-package}
\title{The walkr package.}
\usage{
walkr(A, b, points, method = "dikin", thin = 1, burn = 0, chains = 1,
  ret.format = "matrix")
}
\arguments{
\item{A}{is the lhs of the matrix equation A}

\item{b}{is the rhs of the matrix equation b}

\item{points}{is the number of points we want to sample}

\item{method}{is the MCMC sampling method. Please enter "hit-and-run", "dikin", or "
optimized-dikin"}

\item{thin}{every thin-th point is stored}

\item{burn}{the first burn points are deleted}

\item{chains}{is the number of chains we run}

\item{ret.format}{is the format in which walkr returns the answer. Please
       enter "list" (of chains) or "matrix".}
}
\value{
Either a list of chains (with each chain as a matrix of points) or
        a matrix containing all the points. Each column is a point sampled.
}
\description{
\tabular{ll}{ Package \tab walkr \cr Type: \tab Package\cr
Version: \tab 0.3.1\cr Date: \tab 2015-07-14\cr License: \tab GPL-3\cr }

Given \eqn{Ax = b}, \code{walkr} samples points from the intersection of
\eqn{Ax = b} with the n-simplex (\eqn{\sum x = 1}, \eqn{x_i \ge 0}). The
Ax = b must be underdetermined, otherwise there is an unique solution
and there will be no sampling.
}
\details{
The \code{walkr} package samples points using MCMC random walks from the
intersection of the \eqn{N}-Simplex with \eqn{M} hyperplanes. Mathematically
speaking, the sampling space is all vectors \eqn{x} that satisfy
\eqn{Ax = b}, \eqn{\sum x  = 1}, and \eqn{x_i \ge 0}. The sampling
algorithms implemented are hit-and-run and Dikin Walk. \code{walkr} also
provides tools to examine and visualize the convergence properties of the
random walks.

The main function of the package is \code{walkr}. The user specifies \eqn{A} and
\eqn{b} in \eqn{Ax = b}, and the \code{walkr} function samples points
from the complete solution to \eqn{Ax=b} intersected with the \eqn{N}-simplex.
The user can choose either \code{"dikin"} or \code{"hit-and-run"} as the
sampling method, and the function also provides other MCMC parameters
such as thinning and burning.

Before the sampling, walkr internally performs the affine transformation
which takes the complete solution of \eqn{Ax = b} and that intersected
with the unit simplex into a space parametrized by coefficients, which
we call the "alpha-space". The specific set of procedures taken is
written in detail in the vignette. Essentially, the space is transformed,
the sampling takes place in the transformed space, and in the end
\code{walkr} transforms back into the original coordinate system
and returns the result. This transformation is affine, so the uniformity
and mixing properties of the MCMC algorithms are not affected.
The current MCMC sampling methods supported are "hit-and-run",
"dikin" and "optimized-dikin" (a Rcpp boosted version for speed).

1) Hit-and-run is computationally less expensive and also
guarantees uniformity asympotically with complexity of O(n^3)
points with respect to dimension n. However, in real practice,
as dimensions ramp up, the mixing of hit-and-run is poor compared
to Dikin. Thus, a lot of thinning would be needed as dimension
ramps up.

2) Dikin Walk is a nearly uniform method known for its very strong
mixing properties. However, each Dikin step is much more
computationally expensive than hit-and-run, so it takes more time
to sample every point. Thus, the "dikin" method
uses RcppEigen to speed up the core computationally
expensive operations in the algorithm.
}
\examples{
## 4D constraint
A <- matrix(c(2,0,1,3), ncol = 4)
b <- 0.5
sampled_points <- walkr(A = A, b = b, points = 100, method = "dikin")
}

