% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wpd_features.R
\name{wpd_features}
\alias{wpd_features}
\title{Measure wavelet packet decomposition features (EXPERIMENTAL)}
\usage{
wpd_features(X, normalize = TRUE, threshold1 = 6, 
threshold2 = 0.5, path = NULL, pb = TRUE, parallel = 1)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The output of \code{\link{manualoc}} or \code{\link{autodetec}} can
also be used as the input data frame.}

\item{normalize}{Logical to determine if features are normalized by signal duration.}

\item{threshold1}{Threshold (\%) for wavelet coefficient detection. Equivalent to denominator of equation 6 in Selin et al (2007). Must be a value between 0 and 1.}

\item{threshold2}{Threshold for width detection. Equivalent to threshold 2 (th2) in equation 7 in Selin et al (2007).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}
}
\description{
\code{wpd_features} Measure wavelet packet decomposition features.
}
\details{
Measures wavelet packet decomposition features. STILL IN DEVELOPMENT. USE IT UNDER YOUR OWN RISK.
}
\examples{
{
data(list = c("Phae.long1", "Phae.long2", "lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "Phae.long2.wav"))

# not normalize
wpd_features(lbh_selec_table[1:5, ], threshold2 = 0.3, nor = FALSE)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
Selin A., J. Turunen, and J. T. Tanttu, 2007. Wavelets in recognition of bird sounds. EURASIP Journal on Advances in Signal Processing.
}
}
\seealso{
\code{\link{mfcc_stats}}, \code{\link{mfcc_stats}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
