% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xcmaps.R
\name{xcmaps}
\alias{xcmaps}
\title{Maps of 'Xeno-Canto' recordings by species}
\usage{
xcmaps(X, img = TRUE, it = "jpeg", res = 100, labels = FALSE,
 path = NULL)
}
\arguments{
\item{X}{Data frame output from \code{\link{querxc}}.}

\item{img}{A logical argument specifying whether an image file of each species
map should be returned, default is \code{TRUE}.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/ 
presentation quality.}

\item{labels}{A logical argument defining whether dots depicting recording locations are labeled.
If \code{TRUE} then the Recording_ID is used as label.}

\item{path}{Character string with the directory path where the image files will be saved. 
If \code{NULL} (default) then the current working directory is used.
Ignored if \code{img = FALSE}.}
}
\value{
A map of 'Xeno-Canto' recordings per species (image file), or a faceted
  plot of species map(s) in the active graphic device.
}
\description{
\code{xcmaps} creates maps to visualize the geographic spread of 'Xeno-Canto'
  recordings.
}
\details{
This function creates maps for visualizing the geographic spread of recordings from the open-access
online repository  \href{http://www.xeno-canto.org/}{Xeno-Canto}. The function takes the output of 
\code{\link{querxc}} as input. Maps can be displayed in the graphic device or saved as images in the
working directory.
}
\examples{
\dontrun{
# search in xeno-canto
X <- querxc("Phaethornis anthophilus", download = FALSE)

#create image in R graphic device
xcmaps(X, img = FALSE)
}

}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com}) and Grace Smith Vidaurre
}
