% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consolidate.R
\name{consolidate}
\alias{consolidate}
\title{Consolidate (sound) files into a single directory}
\usage{
consolidate(files = NULL, path = NULL, dest.path = NULL, pb = TRUE, file.ext = ".wav$", 
parallel = 1, save.csv = TRUE, ...)
}
\arguments{
\item{files}{character vector or factor indicating the subset of files that will be analyzed. The files names
should include the full file path. Optional.}

\item{path}{Character string containing the directory path where the sound files are located. 
'wav.path' set by \code{\link{warbleR_options}} is ignored. 
If \code{NULL} (default) then the current working directory is used.}

\item{dest.path}{Character string containing the directory path where the sound files will be saved.
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{file.ext}{Character string defining the file extension for the files to be consolidated. Default is \code{'.wav$'} ignoring case.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{save.csv}{Logical. Controls whether a data frame containing sound file information is saved in the new directory. Default is \code{TRUE}.}

\item{...}{Additional arguments to be passed to the internal \code{\link[base:files]{file.copy}} function for customizing file copying.}
}
\value{
All (sound) files are consolidated (copied) to a single directory ("consolidated_files"). The function returns a data frame with each of the files that were copied in a row and the following information:
\itemize{
 \item \code{original_dir} the path to the original file 
 \item \code{old_name} the name of the original file
 \item \code{new_name} the name of the new file. This will be the same as 'old_name' if the name was not duplicated (i.e. no files in other directories with the same name).
 \item \code{file_size_bytes} size of the file in bytes.
 \item \code{duplicate} indicates whether a file is likely to be duplicated (i.e. if files with the same name were found in other directories). If so it will be labeled as 'possible.dupl', otherwise it will contain NAs. 
}
If \code{csv = TRUE} (default)
a 'file_names_info.csv' file with the same information as the output data frame is also saved in the consolidated directory.
}
\description{
\code{consolidate} copies (sound) files scattered in several directories into a single one.
}
\details{
This function allows users to put files scattered in several directories into a 
single one. By default it works on sound files in '.wav' format but can work with
other type of files (for instance '.txt' selection files).
}
\examples{
{ 
# save wav file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "lbh_selec_table"))

# create first folder with 2 sound files
dir.create(file.path(tempdir(), "folder1"))
writeWave(Phae.long1, file.path(tempdir(), "folder1", "Phae.long1.wav"))
writeWave(Phae.long2, file.path(tempdir(), "folder1", "Phae.long2.wav"))

# create second folder with 2 sound files
dir.create(file.path(tempdir(), "folder2"))
writeWave(Phae.long3, file.path(tempdir(), "folder2", "Phae.long3.wav"))
writeWave(Phae.long4, file.path(tempdir(), "folder2", "Phae.long4.wav"))

# consolidate in a single folder
# consolidate(path = tempdir(), dest.path = tempdir())

# check this folder
tempdir()
}

}
\references{
{Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.}
}
\seealso{
\code{\link{fixwavs}} for making sound files readable in R
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
\concept{sound file manipulation}
