% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track_harm.R
\name{track_harm}
\alias{track_harm}
\title{Track harmonic frequency contour}
\usage{
track_harm(wave, f, wl = 512, wn = "hanning", ovlp = 0, fftw = FALSE, at = NULL, 
tlim = NULL, threshold = 10, bandpass = NULL, clip = NULL, plot = TRUE, 
xlab = "Times (s)", ylab = "Frequency (kHz)",  ylim = c(0, f/2000),
adjust.wl = FALSE, dfrq = FALSE, ...)
}
\arguments{
\item{wave}{A 'wave' object produced by \code{\link[tuneR]{readWave}} or similar functions.}

\item{f}{Sampling frequency of the wave object (in Hz). Does not need to be specified if embedded in wave.}

\item{wl}{A numeric vector of length 1 specifying the window length for the FFT, default 
is 512.}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options. This is used for calculating the frequency spectrum (using \code{\link[seewave]{meanspec}}) and producing the spectrogram (using \code{\link[seewave]{spectro}}, if \code{plot = TRUE}).}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive time windows, as in \code{\link[seewave]{spectro}}. Default is 0.}

\item{fftw}{if TRUE calls the function FFT of the library fftw. See Notes of the \code{\link[seewave]{spectro}} function.
Default is \code{FALSE}.}

\item{at}{Time position where the harmonic frequency contour has to be computed (in seconds). Default is \code{NULL}.}

\item{tlim}{time range in which to measure frequency contours. Default is \code{NULL} (which means it will measure 
across the entire wave object).}

\item{threshold}{Amplitude threshold (\%) for dominant frequency and detection. Default is 10.}

\item{bandpass}{A numeric vector of length 2 for the lower and upper limits of a frequency bandpass filter (in kHz).}

\item{clip}{A numeric value to select dominant frequency values according to their amplitude in reference to a maximal value of 1 for the whole signal (has to be >0 & < 1).}

\item{plot}{Logical, if TRUE plots the dominant frequency against time. Default is \code{TRUE}.}

\item{xlab}{Label of the time axis.}

\item{ylab}{Label of the frequency axis.}

\item{ylim}{A numeric vector of length 2 for the frequency limit of 
the spectrogram (in kHz), as in \code{\link[seewave]{spectro}}. Default is c(0, f/2000).}

\item{adjust.wl}{Logical. If \code{TRUE} 'wl' (window length) is reset to be lower than the 
number of samples in a selection if the number of samples is less than 'wl'. Default is \code{FALSE}.}

\item{dfrq}{Logical. If \code{TRUE} seewave's \code{\link[seewave]{dfreq}} is used instead. Default is \code{FALSE}.}

\item{...}{Additional arguments to be passed to the plotting function.}
}
\description{
\code{track_harm} tracks the frequency contour of the dominant harmonic.
}
\details{
This is a modified version of seewave's \code{\link[seewave]{dfreq}} function that allows to track the frequency 
contour of a dominant harmonic even when the highest amplitude jumps between harmonics. The arguments and default values of the
original \code{\link[seewave]{dfreq}} function have been kept unchanged to facilitate switching between the 2 functions.
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{trackfreqs}} for tracking frequencies iteratively on selections tables.
}
\author{
Jerome Sueur, modified by Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr})
}
