% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.methods.R
\name{compare.methods}
\alias{compare.methods}
\title{Assessing the performance of acoustic distance measurements}
\usage{
compare.methods(X = NULL, flim = c(0, 22), bp = c(0, 22), mar = 0.1, wl = 512, ovlp = 90, 
res = 150, n = 10, length.out = 30, methods = c("XCORR", 
"dfDTW", "ffDTW", "SP"),it = "jpeg", parallel = 1, path = NULL, sp = NULL, pb = TRUE)
}
\arguments{
\item{X}{Data frame with results from \code{\link{manualoc}} function, \code{\link{autodetec}} 
function, or any data frame with columns for sound file name (sound.files), 
selection number (selec), and start and end time of signal (start and end).
Default \code{NULL}.}

\item{flim}{A numeric vector of length 2 for the frequency limit in kHz of 
the spectrogram, as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{bp}{numeric vector of length 2 giving the lower and upper limits of the 
frequency bandpass filter (in kHz) used in the acoustic distance methods. Default is c(0, 22).}

\item{mar}{Numeric vector of length 1. Specifies plot margins around selection in seconds. Default is 0.1.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{ovlp}{Numeric vector of length 1 specifying the percent overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 90.}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 150.}

\item{n}{Numeric argument of length 1. Defines the number of plots to be produce. 
Default is 10.}

\item{length.out}{A character vector of length 1 giving the number of measurements of fundamental or dominant
frequency desired (the length of the time series). Default is 30.}

\item{methods}{A character vector of length 2 giving the names of the acoustic distance
methods that would be compared. The methods available are: cross-correlation (XCORR, from
\code{xcorr}), dynamic time warping on dominant frequency time series (dfDTW, from
 \code{\link[dtw]{dtw}} applied on \code{dfts} output), dynamic time warping on dominant 
 frequency time series (ffDTW, from \code{\link[dtw]{dtw}} applied on \code{ffts} output),
  spectral parameters (SP, from \code{specan}).}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). 
Not available in Windows OS.}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{sp}{Data frame with acoustic parameters as the one generated by \code{specan}. Must contain 'sound.files'
and "selec' columns and the same selections as in 'X'.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}
}
\value{
Image files with 4 spectrograms of the selection being compared and scatterplots 
of the acoustic space of all signals in the input data frame 'X'.
}
\description{
\code{compare.methods} creates graphs to visually assess performance of acoustic distance measurements
}
\details{
This function produces graphs with spectrograms from 4 selections that allow visual inspection of the performance of acoustic distance methods at comparing those selections. The spectrograms are all plotted with the same frequency and time scales. The function compares 2 methods at a time. The methods available are: cross
-correlation (XCORR, from \code{xcorr}), dynamic time warping on dominant frequency time 
series (dfDTW, from \code{\link[dtw]{dtw}} applied on \code{dfts} output), dynamic time 
warping on dominant frequency time series (ffDTW, from \code{\link[dtw]{dtw}} applied on 
\code{ffts} output), spectral parameters (SP, from \code{specan}). The graph also 
contains 2 scatterplots (1 for each method) of the acoustic space of all signals in the 
input data frame 'X'. The compared selections are randomly picked up from the pool of 
selections in the input data frame. The argument 'n' defines the number of comparison (e
.i. graphs) to be produced. The acoustic pairwise distance between signals is shown next 
to the arrows linking them. The font color of a distance value correspond to the font 
color of the method that generetad it, as shown in the scatterplots. Distances are 
standardize, being 0 the distance of a signal to itself and 1 the farthest pairwise 
distance in the pool of signals. Principal Component Analysis (\code{\link[stats]{princomp}}) 
is applied to calculate distances when using spectral parameters (SP). In that case the first 2 PC's are used. Classical 
Multidimensional Scalling (also knwon as Principal Coordinates Analysis, 
(\code{\link[stats]{cmdscale}})) is used for all other methods. Note that SP can only be used with at least 22 selections (number of rows in input data frame) as PCA only works with more units than variables. The graphs are return as image files in the 
working directory. The file name contains the methods being compared and the 
rownumber of the selections. This function uses internally a modified version
of the \code{\link[seewave]{spectro}} function from seewave package to create spectrograms.
}
\examples{
\dontrun{
# First create empty folder
setwd(tempdir())

data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "manualoc.df"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

compare.methods(X = manualoc.df, flim = c(0, 10), bp = c(0, 10), mar = 0.1, wl = 300,
ovlp = 90, res = 200, n = 10, length.out = 30,
methods = c("XCORR", "dfDTW"), parallel = 1, it = "jpeg")

#remove progress bar
compare.methods(X = manualoc.df, flim = c(0, 10), bp = c(0, 10), mar = 0.1, wl = 300,
ovlp = 90, res = 200, n = 10, length.out = 30,
methods = c("XCORR", "dfDTW"), parallel = 1, it = "jpeg", pb = FALSE)

#check this folder!
getwd()
}

}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}). It uses 
internally a modified version of the \code{\link[seewave]{spectro}} function from 
seewave package to create spectrograms.
}

