% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trackfreqs.R
\name{trackfreqs}
\alias{trackfreqs}
\title{Spectrograms with frequency measurements}
\usage{
trackfreqs(X, wl = 512, flim = c(0, 22), wn = "hanning", pal =
  reverse.gray.colors.2, ovlp = 70, inner.mar = c(5, 4, 4, 2), outer.mar = 
  c(0, 0, 0, 0), picsize = 1, res = 100, cexlab = 1, title = TRUE, propwidth = FALSE, 
  xl = 1, osci = FALSE, gr = FALSE, sc = FALSE, bp = c(0, 22), cex = c(0.6, 1), 
  threshold = 15, contour = "both", col = c("skyblue", "red2"),
   pch = c(21, 24),  mar = 0.05, lpos = "topright", it = "jpeg", parallel = 1, 
   path = NULL, img.suffix = NULL, custom.contour = NULL, pb = TRUE, type = "p", 
   leglab = c("Ffreq", "Dfreq"), col.alpha = 0.6, line = TRUE)
}
\arguments{
\item{X}{Data frame with results containing columns for sound file name (sound.files), 
selection number (selec), and start and end time of signal (start and end).
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used as the input data frame.}

\item{wl}{A numeric vector of length 1 specifying the window length of the spectrogram, default 
is 512.}

\item{flim}{A numeric vector of length 2 for the frequency limit of 
the spectrogram (in kHz), as in \code{\link[seewave]{spectro}}. Default is c(0, 22).}

\item{wn}{Character vector of length 1 specifying window name. Default is 
"hanning". See function \code{\link[seewave]{ftwindow}} for more options.}

\item{pal}{A color palette function to be used to assign colors in the 
plot, as in \code{\link[seewave]{spectro}}. Default is reverse.gray.colors.2.}

\item{ovlp}{Numeric vector of length 1 specifying \% of overlap between two 
consecutive windows, as in \code{\link[seewave]{spectro}}. Default is 70.}

\item{inner.mar}{Numeric vector with 4 elements, default is c(5,4,4,2). 
Specifies number of lines in inner plot margins where axis labels fall, 
with form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{outer.mar}{Numeric vector with 4 elements, default is c(0,0,0,0). 
Specifies number of lines in outer plot margins beyond axis labels, with 
form c(bottom, left, top, right). See \code{\link[graphics]{par}}.}

\item{picsize}{Numeric argument of length 1. Controls relative size of 
spectrogram. Default is 1.}

\item{res}{Numeric argument of length 1. Controls image resolution.
Default is 100 (faster) although 300 - 400 is recommended for publication/ 
presentation quality.}

\item{cexlab}{Numeric vector of length 1 specifying the relative size of axis 
labels. See \code{\link[seewave]{spectro}}.}

\item{title}{Logical argument to add a title to individual spectrograms. 
Default is \code{TRUE}.}

\item{propwidth}{Logical argument to scale the width of spectrogram 
proportionally to duration of the selected call. Default is \code{FALSE}.}

\item{xl}{Numeric vector of length 1. A constant by which to scale 
spectrogram width. Default is 1.}

\item{osci}{Logical argument to add an oscillogram underneath spectrogram, as
in \code{\link[seewave]{spectro}}. Default is \code{FALSE}.}

\item{gr}{Logical argument to add grid to spectrogram. Default is \code{FALSE}.}

\item{sc}{Logical argument to add amplitude scale to spectrogram, default is 
\code{FALSE}.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "frange" to indicate that values in low.f 
and high.f columns will be used as bandpass limits. Default is c(0, 22).}

\item{cex}{Numeric vector of length 2, specifies relative size of points 
plotted for frequency measurements and legend font/points, respectively. 
See \code{\link[seewave]{spectro}}.}

\item{threshold}{amplitude threshold (\%) for fundamental frequency and 
dominant frequency detection. Default is 15.}

\item{contour}{Character vector, one of "df", "ff" or "both", specifying whether the
dominant or fundamental frequencies or both should be plotted. Default is "both".}

\item{col}{Vector of length 1 or 2 specifying colors of points plotted to mark 
fundamental and dominant frequency measurements respetively (if both are plotted). Default is c("skyblue",
"red2").}

\item{pch}{Numeric vector of length 1 or 2 specifying plotting characters for 
the frequency measurements. Default is c(21, 24).}

\item{mar}{Numeric vector of length 1. Specifies the margins adjacent to the selections
to set spectrogram limits. Default is 0.05.}

\item{lpos}{Character vector of length 1 or numeric vector of length 2, 
specifiying position of legend. If the former, any keyword accepted by 
xy.coords can be used (see below). If the latter, the first value will be the x 
coordinate and the second value the y coordinate for the legend's position.
Default is "topright".}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{img.suffix}{A character vector of length 1 with a suffix (label) to add at the end of the names of 
image files. Default is \code{NULL}.}

\item{custom.contour}{A data frame with frequency contours for exactly the same sound files and selection as in X. 
The frequency values are assumed to be equally spaced in between the start and end of the signal. The 
first 2 colums of the data frame should contain the 'sound.files' and 'selec' columns and should be 
identical to the corresponding columns in X (same order).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}

\item{type}{A character vector of length 1 indicating the type of frequency contour plot to be drawn. 
Possible types are "p" for points, "l" for lines and "b" for both.}

\item{leglab}{A character vector of length 1 or 2 containing the label(s) of the frequency contour legend 
in the output image.}

\item{col.alpha}{A numeric vector of length 1  within [0,1] indicating how transparent the lines/points should be.}

\item{line}{Logical argument to add red lines (or box if low.f and high.f columns are provided) at start and end times of selection. Default is \code{TRUE}.}
}
\value{
Spectrograms of the signals listed in the input data frame showing the location of 
the dominant and fundamental frequencies.
}
\description{
\code{trackfreqs} creates spectrograms to visualize dominant and fundametal frequency measurements (contours)
of signals selected by \code{\link{manualoc}} or \code{\link{autodetec}}.
}
\details{
This function provides visualization of frequency measurements as the ones 
  made by \code{\link{specan}}. Frequency measures can be made by the function or input by the 
  user (see 'custom.contour' argument)  Arguments that are accepted by xy.coords and can be 
  used for 'lpos' are: "bottomright", "bottom", "bottomleft", "left", 
  "topleft", "top", "topright", "right" and "center". Setting inner.mar to 
  c(4,4.5,2,1) and outer.mar to c(4,2,2,1) works well when picsize = 2 or 3. 
  Title font size, inner.mar and outer.mar (from mar and oma) don't work well
  when osci or sc = TRUE, this may take some optimization by the user. Note that if no amplitude was detected
  for a particular time bin, then the image will show a dark dot at the bottom of the time bin.
}
\examples{
\dontrun{
#Set temporal folder as working directory
setwd(tempdir())

#load data
data("Cryp.soui")
writeWave(Cryp.soui, "Cryp.soui.wav") #save sound files 

#autodetec location of signals
ad <- autodetec(threshold = 6, bp = c(1, 3), mindur = 1.2,
maxdur = 3, img = FALSE, ssmooth = 600, wl = 300, flist = "Cryp.soui.wav")

#track dominant frequency graphs
trackfreqs(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, it = "tiff",
bp = c(1, 3), contour = "df", wl = 300)

#using users frequency data (custom.contour argument) 
#first get contours using dfts
df <- dfts(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, img = FALSE,
bp = c(1, 3),  wl = 300)

# now input the dfts output into trackfreqs         
trackfreqs(X = ad[!is.na(ad$start),], custom.contour = df ,flim = c(0, 5), ovlp = 90, it = "tiff")

# Check this folder
getwd()

#track both frequencies 
trackfreqs(X = ad[!is.na(ad$start),], flim = c(0, 5), ovlp = 90, it = "tiff",
bp = c(1, 3), contour = "both", wl = 300)

}
}
\author{
Grace Smith Vidaurre and Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
\seealso{
\code{\link{specreator}} for creating spectrograms from selections,
 \code{\link{snrspecs}} for creating spectrograms to 
  optimize noise margins used in \code{\link{sig2noise}}

Other spectrogram.creators: \code{\link{dfDTW}},
  \code{\link{dfts}}, \code{\link{ffDTW}},
  \code{\link{ffts}}, \code{\link{snrspecs}},
  \code{\link{sp.en.ts}}, \code{\link{specreator}}
}

