% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_netRadiation.G.R
\name{incLWradiation}
\alias{incLWradiation}
\title{Calculates long wave incoming radiation}
\usage{
incLWradiation(WeatherStation, DEM, solar.angles, Ts)
}
\arguments{
\item{WeatherStation}{Weather Station data}

\item{DEM}{digital elevation model in meters.}

\item{solar.angles}{rasterStack with latitude, declination, hour.angle, incidence.hor and incidence.rel. See solarAngles()}

\item{Ts}{Land surface temperature. See surfaceTemperature()}
}
\description{
This function estimates the long wave incoming radiation using the Stefan-Boltzmann equation. In addition, empirical equation of Bastiaanssen (1995) with coefficients developed by Allen (2000) are used to estimate the effective atmospheric emissivity.
}
\references{
R. G. Allen, M. Tasumi, and R. Trezza, "Satellite-based energy balance for mapping evapotranspiration with internalized calibration (METRIC) - Model" Journal of Irrigation and Drainage Engineering, vol. 133, p. 380, 2007 \cr

Bastiaanssen W. Regionalization of surface flux densities and moisture indicators in composite terrain: A remote sensing approach under clear skies in Mediterranean climates. Ph.D. dissertation, CIP Data Koninklijke Bibliotheek, Den Haag, The Netherlands, 1995, p273 \cr

Allen R. RAPID long-wave radiation calculations and model comparisons Internal report, University of Idaho, Kimberly, Idaho, 2000 \cr
}
\seealso{
Other net radiation related functions: \code{\link{LAI}},
  \code{\link{METRICtopo}}, \code{\link{SWtrasmisivity}},
  \code{\link{albedo}}, \code{\link{incSWradiation}},
  \code{\link{netRadiation}}, \code{\link{outLWradiation}},
  \code{\link{soilHeatFlux}}, \code{\link{solarAngles}},
  \code{\link{surfaceTemperature}}
}
\author{
Guillermo Federico Olmedo

Fonseca-Luengo, David
}
