% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percentile.location.R
\name{percentile.location}
\alias{percentile.location}
\title{percentile.location}
\usage{
percentile.location(x, quan = seq(0.5, 1, 0.1), rescale = TRUE,
  top = TRUE)
}
\arguments{
\item{x}{is the waveform intensities. If you have other information, you should delete these intensites before you run this function .}

\item{quan}{is the quantile of energy you are interested in. Defalut is seq(0.5,1,0.1).}

\item{rescale}{is to determine whether you want to rescale the waveform intensity or not. Here we used the minimum intensity of each waveform to conduct rescaling.
Default is using rescaling.}

\item{top}{is to tell whether we calculate the percentile from the top (where waveform starts or canopy) or from the bottom (where the waveform ends). Default is from the top.}
}
\value{
return the index or position of corressponding quantile energy of waveform starting from the top.
}
\description{
The function allows you to calculate the time location position of energy percentile based on the given quantile within a waveform.
With this information. In addition, you can calculate the energy percentile heights.
Here, the percentile will be calculated from the top (more likely the canopy part) by defalut.
}
\examples{

data(return)
x<-return[1,]
#default
percentile.location(x)

#change the quantile
qr<-seq(0.45,0.99,0.05)
re1<-percentile.location(x,quan=qr)
###rescale affects your results
re2<-percentile.location(x,quan=qr,rescale = FALSE)
##after you get the index, you can convert them to the height
#based on temporal resolution or georeference information of this waveform.
}
