% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotSpectra.R
\name{PlotSpectra}
\alias{PlotSpectra}
\title{Plot spectral data, highlighting outliers as identified using
 Mahalanobis distance}
\usage{
PlotSpectra(input.df, wavelengths, num.col.before.spectra = 1,
  window.size = 10, verbose = TRUE)
}
\arguments{
\item{input.df}{\code{data.frame} object containing columns of spectra.
Spectral columns must be labeled with an "X" and then the wavelength
(example: "X740" = 740nm). Left-most column must be unique ID. May also
contain columns of metadata between the unique ID and spectral columns.
Cannot contain any missing values}

\item{wavelengths}{List of wavelengths (numerical format) represented by each
spectral column in \code{input.df}}

\item{num.col.before.spectra}{Number of columns to the left of the spectral
matrix (including unique ID). Default is 1.}

\item{window.size}{number defining the size of window to use when calculating
the covariance of the spectra (required to calculate Mahalanobis distance).
Default is 10.}

\item{verbose}{If \code{TRUE}, the number of rows removed through filtering
will be printed to the console. Default is \code{TRUE}.}
}
\value{
If verbose, prints unique ID and metadata for rows identified as outliers.
 Returns plot of spectral data with non-outliers in blue and outliers in red.
 X-axis is wavelengths and y-axis is spectral values.
}
\description{
Generates a \code{\link[ggplot2]{ggplot}} object of given
 spectra, with wavelength on the x axis and given spectral values on the y.
 Mahalanobis distance is used to calculate outliers, which are both
 identified on the plot. Rows from the original dataframe are printed to the
 console for each outlier that is identified.
}
\examples{
\donttest{
library(magrittr)
ikeogu.2017 \%>\%
  dplyr::rename(unique.id = sample.id) \%>\%
  dplyr::select(unique.id, dplyr::everything(), -TCC) \%>\%
  na.omit() \%>\%
  PlotSpectra(input.df = .,
              wavelengths = 350:2500,
              num.col.before.spectra = 5,
              window.size = 15)
}
}
\author{
Jenna Hershberger \email{jmh579@cornell.edu}
}
