\name{ortho.basis}
\alias{ortho.basis}
\title{Derive Orthonormal Basis from Wavelet Packet Tree}
\description{
  An orthonormal basis for the discrete wavelet transform may be
  characterized via a disjoint partitioning of the frequency axis that
  covers \eqn{[0,\frac{1}{2})}{[0,1/2)}.  This subroutine produces an
  orthonormal basis from a full wavelet packet tree.
}
\usage{ortho.basis(xtree)
}
\arguments{
  \item{xtree}{is a vector whose entries are associated with a wavelet
    packet tree.}
}
\value{
  Boolean vector describing the orthonormal basis for the DWPT.
}
\details{
  A wavelet packet tree is a binary tree of Boolean variables.  Parent
  nodes are removed if any of their children exist.
}
%\references{}
%\seealso{}
\examples{
data(japan)
J <- 4
wf <- "mb8"
japan.mra <- mra(log(japan), wf, J, boundary="reflection")
japan.nomean <-
  ts(apply(matrix(unlist(japan.mra[-(J+1)]), ncol=J, byrow=FALSE), 1, sum),
     start=1955, freq=4)
japan.nomean2 <- ts(japan.nomean[42:169], start=1965.25, freq=4)
plot.ts(japan.nomean2)
japan.dwpt <- dwpt(japan.nomean2, wf, 6)
japan.basis <-
  ortho.basis(portmanteau.test(japan.dwpt, p=0.01, type="other"))
# Not implemented yet
# par(mfrow=c(1,1))
# plot.basis(japan.basis)
}
\author{B. Whitcher}
\keyword{ts}
