% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_prob_mix}
\alias{plot_prob_mix}
\title{Probability Plot for Separated Mixture Models}
\usage{
plot_prob_mix(x, y, event, id = rep("XXXXXX", length(x)),
  distribution = c("weibull", "lognormal", "loglogistic"),
  reg_output = NULL, title_main = "Probability Plot",
  title_x = "Characteristic", title_y = "Unreliability",
  title_trace = "Sample")
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{y}{a numeric vector which consists of estimated failure probabilities
regarding the lifetime data in \code{x}.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{id}{a character vector for the identification of every unit.}

\item{distribution}{supposed distribution of the random variable. Can be
\code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}. Other
distributions have not been implemented yet.}

\item{reg_output}{a list provided by \code{\link{mixmod_regression}} which
consists of values necessary to visualize the segments calculated by
\code{\link{mixmod_regression}}.The default value of \code{reg_output} is
\code{NULL}.}

\item{title_main}{a character string which is assigned to the main title
of the plot.}

\item{title_x}{a character string which is assigned to the title of the
x axis.}

\item{title_y}{a character string which is assigned to the title of the
y axis.}

\item{title_trace}{a character string whis is assigned to the trace shown in
the legend.}
}
\value{
Returns a plotly object containing the layout of the probability plot
  provided by \code{\link{plot_layout}} and the plotting positions.
}
\description{
This function is used to apply the graphical technique of probability
plotting to univariate mixture models that where separated with the function
\code{\link{mixmod_regression}}. A maximum of three subgroups can be plotted.
The intention of this function is to give the user a hint for the existence
of a mixture model. An in-depth analysis should be done afterwards.
}
\details{
The marker label for x is determined by the first word provided in the
argument \code{title_x}, i.e. if \code{title_x = "Mileage in km"} the x label
of the marker is "Mileage".

The marker label for y is determined by the string provided in the
argument \code{title_y}, i.e. if \code{title_y = "Probability in percent"} the y
label of the marker is "Probability".
}
\examples{
hours <- c(2, 28, 67, 119, 179, 236, 282, 317, 348, 387, 3, 31, 69, 135,
          191, 241, 284, 318, 348, 392, 5, 31, 76, 144, 203, 257, 286,
          320, 350, 412, 8, 52, 78, 157, 211, 261, 298, 327, 360, 446,
          13, 53, 104, 160, 221, 264, 303, 328, 369, 21, 64, 113, 168,
          226, 278, 314, 328, 377)
state <- c(1, 1, 0, 1, 0, 1, 1, 1, 1, 1, 1, 1, 1, 0, 1, 0, 1,
          1, 0, 1, 1, 0, 1, 1, 1, 0, 1, 1, 1, 1, 1, 0, 0, 0,
          1, 1, 1, 1, 1, 1, 0, 0, 1, 1, 1, 1, 1, 1, 1, 1, 1,
          0, 1, 1, 1, 1, 1, 1)
john <- johnson_method(x = hours, event = state)

mix_mod <- mixmod_regression(x = john$characteristic,
                             y = john$prob,
                             event = john$status,
                             distribution = "weibull")

plot_weibull_mix <- plot_prob_mix(x = john$characteristic,
                                  y = john$prob,
                                  event = john$status,
                                  id = john$id,
                                  distribution = "weibull",
                                  reg_output = mix_mod,
                                  title_main = "Mixture Weibull Analysis",
                                  title_x = "Time in Hours",
                                  title_y = "Probability of Failure",
                                  title_trace = "classification")
}
