% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/terrain_analysis.R
\name{wbt_max_elevation_deviation}
\alias{wbt_max_elevation_deviation}
\title{Max elevation deviation}
\usage{
wbt_max_elevation_deviation(
  dem,
  out_mag,
  out_scale,
  min_scale,
  max_scale,
  step = 1,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{out_mag}{Output raster DEVmax magnitude file.}

\item{out_scale}{Output raster DEVmax scale file.}

\item{min_scale}{Minimum search neighbourhood radius in grid cells.}

\item{max_scale}{Maximum search neighbourhood radius in grid cells.}

\item{step}{Step size as any positive non-zero integer.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by WhiteboxTools to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates the maximum elevation deviation over a range of spatial scales.
}
