% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query-page-properties.R
\name{query_page_properties}
\alias{query_page_properties}
\alias{list_all_property_modules}
\title{Choose properties to return for pages from the action API}
\usage{
query_page_properties(.req, property, ...)

list_all_property_modules()
}
\arguments{
\item{.req}{A httr2_request, e.g. generated by \code{wiki_action_request}}

\item{property}{The property to request}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> Additional parameters to pass, e.g. to modify what is returned by
the property request}
}
\value{
An HTTP response: an S3 list with class httr2_request
}
\description{
See \href{https://www.mediawiki.org/wiki/API:Properties}{API:Properties} for a
list of available properties. Many have additional parameters to control
their behavior, which can be passed to this function as named arguments.
}
\details{
\link{query_page_properties} is not useful on its own. It must be combined with a
\link{query_by_} function or \link{query_generate_pages} to specify which pages
properties are to be returned. It should be noted that many of the
\href{https://www.mediawiki.org/wiki/API:Properties}{API:Properties} modules can
themselves be used as generators. If you wish to use a property module in
this way, then you must use \link{query_generate_pages}, passing the name of the
property module as the \code{genenerator}.
}
\examples{
# Search for articles about seagulls and retrieve their number of
# watchers

resp <- wiki_action_request() \%>\%
  query_generate_pages("search", gsrsearch = "seagull") \%>\%
  query_page_properties("info", inprop = "watchers") \%>\%
  gracefully(next_batch) \%>\%
  dplyr::select(pageid, ns, title, watchers)
resp
}
\seealso{
\code{\link[=gracefully]{gracefully()}}
}
