% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui.R
\name{wildcard}
\alias{wildcard}
\title{Function \code{wildcard}}
\usage{
wildcard(df, rules = NULL, wildcard = NULL, values = NULL,
  expand = TRUE)
}
\arguments{
\item{df}{data frame}

\item{rules}{list with names a wildcards and elements as vectors of values
to substitute in place of the wildcards.}

\item{wildcard}{character scalar, a wildcard found in a data frame}

\item{values}{vector of values to substitute in place of a wildcard}

\item{expand}{logical, whether to expand the rows of the data frame to substitute
each value for each wildcard in turn. If \code{FALSE}, no new rows
will be added to \code{df} when the values are substituted in place
of wildcards. Can be a vector of length \code{length(rules)} if using the \code{rules}
argument.}
}
\description{
Main function of the package. Evaluate a wildcard
to fill in or expand a data frame.
Copied and modified from \code{drake::evaluate()} package under GPL-3.
}
\examples{
myths <- data.frame(myth = c("Bigfoot", "UFO", "Loch Ness Monster"), 
                    claim = c("various", "day", "day"), 
                    note = c("various", "pictures", "reported day"))
out = wildcard(myths, wildcard = "day", values = c("today", "yesterday"))
wildcard(myths, wildcard = "day", values = c("today", "yesterday"), expand = FALSE)
locations <- data.frame(myth = c("Bigfoot", "UFO", "Loch Ness Monster"), origin = "where")
rules <- list(where = c("North America", "various", "Scotland"), UFO = c("spaceship", "saucer"))
wildcard(locations, rules = rules, expand = c(FALSE, TRUE))
numbers <- data.frame(x = 4, y = 3, z = 4444, w = 4.434)
wildcard(numbers, wildcard = 4, values = 7)
}
