% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Don.R
\name{Don}
\alias{Don}
\title{Doncaster's measure of dynamic interaction}
\usage{
Don(traj, traj2, tc = 0, dc = 0, plot = TRUE)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of at least two individuals. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{traj2}{(optional) same as traj, but for the second group of individuals. See \code{checkTO}}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when two fixes are spatially together.}

\item{plot}{logical, whether or not to plot the Doncaster plot. Default = TRUE.}
}
\value{
A data.frame is returned that contains the values for the contingency table of simultaneous fixes (paired) and non-paired fixes below and above \code{dc}, along with the associated \emph{p}-value from the Chi-squared test.This function can optionally return a plot, for distance values ranging from 0 to the maximum distance separating two fixes, of the observed proportion of simultaneous fixes below each distance value (for each pair). The expected values based on all fixes are also included.
}
\description{
The function \code{Don} measures the dynamic interaction between two moving objects following
the methods outlined by Doncaster (1990).
}
\details{
This function can be used to compute the Doncaster (1990) methods for measuring
dynamic interaction between two objects. The Doncaster method tests the proportion
of simultaneous fixes that are below \code{dc} against that which would be
expected based on the distribution of distances between all fixes.
}
\examples{
data(deer)
#tc = 7.5 minutes, dc = 50 meters
Don(deer, tc = 7.5*60, dc = 50)
}
\references{
Doncaster, C.P. (1992) Non-parametric estimates of interaction from radio-tracking
data. \emph{Journal of Theoretical Biology}, \bold{143}: 431-443.
}
\seealso{
GetSimultaneous
}
\keyword{indices}
