% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/circleBoxInt.R
\name{circleBoxInt}
\alias{circleBoxInt}
\title{Integration of the intersection of a rectangle and an annulus}
\usage{
circleBoxInt(b2, r, b1 = 0, ...)
}
\arguments{
\item{b2}{Numeric, upper integral bound.}

\item{r}{Numeric, circle radius.}

\item{b1}{Numeric, lower integral bound, default is zero.}

\item{...}{Currently ignored.}
}
\value{
Numeric value
}
\description{
Calculate area of annulus bisected by 2 parallel lines to get the
  area of the rectangle that is searched
}
\details{
The integral of a box bounded by the y-axis on the left, \code{b1} or x-axis on the bottom (which every is larger), \code{b2} on the top, and by a circle with radius \code{r} on the right.
\deqn{\int_{b1}^{b2} \sqrt{r^{2} - y^{2}} dy = 1/2(y\sqrt{r^2-y^2} + r^2tan^{-1}(y/\sqrt{r^2 - y^2})) |_{b1}^{b2}}


This is an internal function and intended for use in \code{\link{geometricRectanglePropSearchTable}} and \code{\link{geometricRoadPadPropSearchTable}}
}
\examples{

b2 <- 5
b1 <- 1
r <- 10
circleBoxInt(b2=b2,r=r,b1=b1)

}
