% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barometric_height.R
\name{barometric_height}
\alias{barometric_height}
\title{Calculates Air Density, Air Pressure and Temperature according
to the Barometric Height Formula}
\usage{
barometric_height(data, height, po = 101325, ro = 1.225)
}
\arguments{
\item{data}{A data.frame containing the height values}

\item{height}{Column name of the height values}

\item{po}{Standardized air pressure at sea level (101325 Pa)}

\item{ro}{Standardized air density at sea level (1,225 kg per m3)}
}
\value{
Returns a data.frame with height values and corresponding
air pressures, air densities and temperatures in Kelvin and Celsius.
}
\description{
Calculates air density, temperature and air pressure
    respective to certain heights according to the International
    standard atmosphere and the barometric height formula.
}
\examples{
data <- matrix(seq(0,5000,500));
barometric_height(data)
plot.ts(barometric_height(data))
}
\seealso{
Other Wind Energy Calculation Functions: \code{\link{calculate_energy}},
  \code{\link{get_dist_angles}},
  \code{\link{turbine_influences}}
}
\concept{Wind Energy Calculation Functions}
