% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_windfarmGA}
\alias{plot_windfarmGA}
\title{Plot the results of an optimization run}
\usage{
plot_windfarmGA(
  result,
  Polygon1,
  whichPl = "all",
  best = 1,
  plotEn = 1,
  weibullsrc
)
}
\arguments{
\item{result}{The output of \code{\link{windfarmGA}} or
\code{\link{genetic_algorithm}}}

\item{Polygon1}{The considered area as SpatialPolygon, SimpleFeature Polygon
or coordinates as matrix/data.frame}

\item{whichPl}{Which plots should be shown: 1-6 are possible. The default is
"all" which shows all available plots}

\item{best}{A numeric value indicating how many of the best individuals
should be plotted}

\item{plotEn}{A numeric value that indicates if the best energy or efficiency
output should be plotted. \code{1} plots the best energy solutions
and \code{2} plots the best efficiency solutions}

\item{weibullsrc}{A list of Weibull parameter rasters, where the first list
item must be the shape parameter raster `k` and the second item must be the
scale parameter raster `a` of the Weibull distribution. If no list is given,
then rasters included in the package are used instead, which currently only
cover Austria. This variable is only used if \code{weibull = TRUE}.}
}
\description{
Plot the results of a genetic algorithm run with given inputs.
  Several plots try to show all relevant effects and outcomes of the
  algorithm. 6 plot methods are available that can be selected individually.
}
\examples{
\donttest{
library(sf)
Polygon1 <- sf::st_as_sf(sf::st_sfc(
  sf::st_polygon(list(cbind(
    c(4498482, 4498482, 4499991, 4499991, 4498482),
    c(2668272, 2669343, 2669343, 2668272, 2668272)))), 
  crs = 3035
))

## Plot the results of a hexagonal grid optimization
plot_windfarmGA(resulthex, Polygon1, whichPl = "all", best = 1, plotEn = 1)

## Plot the results of a rectangular grid optimization
plot_windfarmGA(resultrect, Polygon1, whichPl = "all", best = 1, plotEn = 1)
}
}
\seealso{
Other Plotting Functions: 
\code{\link{interpol_view}()},
\code{\link{plot_cloud}()},
\code{\link{plot_development}()},
\code{\link{plot_evolution}()},
\code{\link{plot_fitness_evolution}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_parkfitness}()},
\code{\link{plot_result}()},
\code{\link{plot_viewshed}()},
\code{\link{plot_windrose}()},
\code{\link{random_search_single}()}
}
\concept{Plotting Functions}
