% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ip_desc.R
\name{ip_desc}
\alias{ip_desc}
\title{Generate Integer Partitions in Reverse Lexicographical Order}
\usage{
ip_desc(k)
}
\arguments{
\item{k}{An integer to be partitioned}
}
\value{
A matrix where each row represents an integer partition of \code{k}.
The partitions are listed in reverse lexicographical order.
}
\description{
This function generates all integer partitions of a given integer \code{k} in reverse lexicographical order.
The function is adapted from "Algorithm ZS1" described in Zoghbi and Stojmenovic (1998),
"Fast Algorithms for Generating Integer Partitions", International Journal of Computer Mathematics,
Volume 70, Issue 2, pages 319-332.
}
\examples{
# Example 1:
ip_desc(3)

# Example 2:
ip_desc(5)

}
\references{
Zoghbi, A., & Stojmenovic, I. (1998). Fast Algorithms for Generating Integer Partitions.
International Journal of Computer Mathematics, 70(2), 319-332. DOI: 10.1080/00207169808804755
}
