% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deps-squash.R
\name{squash}
\alias{squash}
\alias{squash.wood_dep_list}
\title{Compress dependencies of multiple packages}
\usage{
squash(object)

\method{squash}{wood_dep_list}(object)
}
\arguments{
\item{object}{\code{wood_dep_list()}\cr
A list of dependencies to compress.}
}
\value{
A \code{data.frame} object similar to these returned by \verb{_dependencies}
functions, but with additional column named \code{origin}.
}
\description{
This function combines multiple dependency lists into a single
\code{data.frame} with additional info about "origin" package, i.e. which package
has this dependency.
}
\examples{
\donttest{
deps <- wood_dependencies(c("versionsort", "deepdep", "gglgbtq"))
squash(deps)
}

}
