% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_publish.R
\name{wflow_publish}
\alias{wflow_publish}
\title{Publish the site}
\usage{
wflow_publish(files = NULL, message = NULL, all = FALSE,
  force = FALSE, update = FALSE, republish = FALSE,
  view = getOption("workflowr.view"), delete_cache = FALSE,
  seed = 12345, verbose = FALSE, dry_run = FALSE, project = ".")
}
\arguments{
\item{files}{character (default: NULL). R Markdown files and other files to
be added and committed with Git (step 1). Any R Markdown files will also be
built (step 2) and their output HTML and figures will be subsequently
committed (step 3). Supports file
\href{https://en.wikipedia.org/wiki/Glob_(programming)}{globbing}.
The files are always built in the order they are listed.}

\item{message}{character (default: NULL). A commit message.}

\item{all}{logical (default: FALSE). Automatically stage files that have been
modified and deleted. Equivalent to: \code{git commit -a}}

\item{force}{logical (default: FALSE). Allow adding otherwise ignored files.
Equivalent to: \code{git add -f}}

\item{update}{logical (default: FALSE). Build any files that have been
committed more recently than their corresponding HTML files (and do not
have any unstaged or staged changes). This ensures that the commit version
ID inserted into the HTML corresponds to the exact version of the source
file that was used to produce it.}

\item{republish}{logical (default: FALSE). Build all published R Markdown
files (that do not have any unstaged or staged changes). Useful for
site-wide changes like updating the theme, navigation bar, or any other
setting in \code{_site.yml}.}

\item{view}{logical (default: \code{getOption("workflowr.view")}). View the
website with \code{\link{wflow_view}} after building files. If only one
file is built, it is opened. If more than one file is built, the main index
page is opened. Not applicable if no files are built or if \code{dry_run =
TRUE}.}

\item{delete_cache}{logical (default: FALSE). Delete the cache directory (if
it exists) for each R Markdown file prior to building it.}

\item{seed}{numeric (default: 12345). The seed to set before building each
file. Passed to \code{\link{set.seed}}. \bold{DEPRECATED:} The seed set
here has no effect if you are using \code{\link{wflow_html}} as the output
format defined in \code{_site.yml}. This argument is for backwards
compatibility with previous versions of workflowr.}

\item{verbose}{logical (default: FALSE). Display the build log directly in
the R console as each file is built. This is useful for monitoring
long-running code chunks.}

\item{dry_run}{logical (default: FALSE). Preview the proposed action but do
not actually add or commit any files.}

\item{project}{character (default: ".") By default the function assumes the
current working directory is within the project. If this is not true,
you'll need to provide the path to the project directory.}
}
\value{
Returns an object of class \code{wflow_publish}, which is a list with
  the following elements:

  \itemize{

  \item \bold{step1}: An object of class \code{wflow_git_commit} from the first
  step of committing the files.

  \item \bold{step2}: An object of class \code{wflow_build} from the second
  step of building the HTML files.

  \item \bold{step3}: An object of class \code{wflow_git_commit} from the third
  step of committing the HTML files.

  }
}
\description{
\code{wflow_publish} is the main workflowr function. Use it when you are
ready to publish an analysis to your site. \code{wflow_publish} performs
three steps: 1) commit the file(s) (can include both Rmd and non-Rmd files,
e.g. \code{_site.yml}), 2) rebuild the R Markdown file(s), 3) commit the
generated website file(s). These steps ensure that the version of the HTML
file is created by the latest version of the R Markdown file, which is
critical for reproducibility.
}
\examples{
\dontrun{
# single file
wflow_publish("analysis/file.Rmd", "Informative commit message")
# All tracked files that have been edited
wflow_publish(all = TRUE, message = "Informative commit message")
# A new file plus all tracked files that have been edited
wflow_publish("analysis/file.Rmd", "Informative commit message", all = TRUE)
# Multiple files
wflow_publish(c("analysis/file.Rmd", "analysis/another.Rmd"),
              "Informative commit message")
# All R Markdown files that start with the pattern "new_"
wflow_publish("analysis/new_*Rmd", "Informative commit message")
# Republish all published files even though they haven't been modified.
# Useful for changing some universal aspect of the site, e.g. the theme
# specified in _site.yml.
wflow_publish("analysis/_site.yml", "Informative commit message",
              republish = TRUE)
# Publish all previously published files that have been committed more
# recently than their corresponding HTML files. This is useful if you like to
# manually commit your R Markdown files.
wflow_publish(update = TRUE)
}

}
\seealso{
\code{\link{wflow_git_commit}}, \code{\link{wflow_build}}
}
