% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wflow_git_config.R
\name{wflow_git_config}
\alias{wflow_git_config}
\title{Configure Git settings}
\usage{
wflow_git_config(user.name = NULL, user.email = NULL, ..., overwrite = FALSE)
}
\arguments{
\item{user.name}{character (default: NULL). Git user name. Git assigns an
author when committing (i.e. saving) changes. If you have never used Git
before on your computer, make sure to set this.}

\item{user.email}{character (default: NULL). Git user email. Git assigns an
email when committing (i.e. saving) changes. If you have never used Git
before on your computer, make sure to set this.}

\item{...}{Arbitrary Git settings, e.g. \code{core.editor = "nano"}.}

\item{overwrite}{logical (default: FALSE). Overwrite existing Git global
settings.}
}
\value{
An object of class \code{wflow_git_config}, which is a list with the
  following elements:

\itemize{

\item \bold{user.name}: The current global Git user.name

\item \bold{user.email}: The current global Git user.email

\item \bold{all_settings}: A list of all current global Git settings

}
}
\description{
\code{wflow_git_config} configures the global Git settings on the current
machine. This is a convenience function to run Git commands from the R
console instead of the Terminal. The same functionality can be achieved by
running \code{git config} in the Terminal.
}
\details{
The main purpose of \code{wflow_git_config} is to set the user.name and
user.email to use with Git commits. Note that these do not need to match the
name and email you used to register your online account with a Git hosting
service (e.g. GitHub or GitLab). However, it can also handle arbitrary Git
settings (see examples below).

There are two main limitations of \code{wflow_git_config} for the sake of
simplicity. First, \code{wflow_git_config} only affects the global Git
settings that apply to all Git repositories on the local machine and is
unable to configure settings for one specific Git repository. Second,
\code{wflow_git_config} can only add or change the user.name and user.email
settings, but not delete them. To perform either of these actions, please use
\code{git config} in the Terminal.

Under the hood, \code{wflow_git_config} is a wrapper for
\code{\link[git2r]{config}} from the package \link{git2r}.

To learn more about how to configure Git, see the Software Carpentry lesson
\href{http://swcarpentry.github.io/git-novice/02-setup/}{Setting Up Git}.
}
\examples{
\dontrun{

# View current Git settings
wflow_git_config()
# Set user.name and user.email
wflow_git_config(user.name = "A Name", user.email = "email@domain")
# Set core.editor (the text editor that Git opens to write commit messages)
wflow_git_config(core.editor = "nano")

}

}
