% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_fotmob.R
\name{load_fotmob_match_details}
\alias{load_fotmob_match_details}
\title{Load pre saved fotmob match details}
\usage{
load_fotmob_match_details(country, league_name, league_id, cached = TRUE)
}
\arguments{
\item{country}{Three character country code. Can be one or multiple. If provided, `league_name` must also be provided (of the same length)}

\item{league_name}{League names. If provided, `country` must also be provided (of the same length).}

\item{league_id}{Fotmob ID for the league. Only used if `country` and `league_name` are not specified.}

\item{cached}{Whether to load the dataframe from the \href{https://github.com/JaseZiv/worldfootballR_data/blob/master/raw-data/fotmob-leagues/all_leagues.csv}{data CSV}. This is faster and most likely what you want to do, unless you identify a league that's being tracked by fotmob that's not in this pre-saved CSV.}
}
\value{
returns a dataframe of league matches
}
\description{
Loading version of \code{fotmob_get_match_details}, but for all seasons for which
data is available, not just the current season.
Note that fotmobonly has match details going back to the 2020-21 season for most leagues.
}
\examples{
\dontrun{
try({
# one league
load_fotmob_match_details(
  country = "ENG",
  league_name = "Premier League"
)

## this is the same output format as the following
fotmob_get_match_details(match_id = 3411352)

# one league, by id
load_fotmob_match_details(league_id = 47)

# multiple leagues (could also use ids)
load_fotmob_match_details(
  country =     c("ENG",            "ESP"   ),
  league_name = c("Premier League", "LaLiga")
)
})
}
}
