% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_query.R
\name{check_query}
\alias{check_query}
\title{Check a query to ensure that it is suitable for analysis}
\usage{
check_query(data, return = "message", validation = FALSE)
}
\arguments{
\item{data}{A person-level query in the form of a data frame. This includes:
\itemize{
\item Standard Person Query
\item Ways of Working Assessment Query
\item Hourly Collaboration Query
}

All person-level query have a \code{PersonId} column and a \code{Date} column.}

\item{return}{String specifying what to return. This must be one of the
following strings:
\itemize{
\item \code{"message"} (default)
\item \code{"text"}
}

See \code{Value} for more information.}

\item{validation}{Logical value to specify whether to return a check used by
the \code{validation_report()}. Defaults to \code{FALSE}. To hide checks on variable
names, set \code{validation} to \code{TRUE}.}
}
\value{
A different output is returned depending on the value passed to the \code{return}
argument:
\itemize{
\item \code{"message"}: a message is returned to the console.
\item \code{"text"}: string containing the diagnostic message.
}
}
\description{
Prints diagnostic data about the data query to the R console,
with information such as date range, number of employees, HR attributes
identified, etc.
}
\details{
This can be used with any person-level query, such as the standard
person query, Ways of Working assessment query, and the hourly collaboration
query. When run, this prints diagnostic data to the R console.
}
\examples{
check_query(sq_data)

}
\seealso{
Other Data Validation: 
\code{\link{extract_hr}()},
\code{\link{flag_ch_ratio}()},
\code{\link{flag_em_ratio}()},
\code{\link{flag_extreme}()},
\code{\link{flag_outlooktime}()},
\code{\link{hr_trend}()},
\code{\link{hrvar_count_all}()},
\code{\link{hrvar_count}()},
\code{\link{identify_churn}()},
\code{\link{identify_holidayweeks}()},
\code{\link{identify_inactiveweeks}()},
\code{\link{identify_nkw}()},
\code{\link{identify_outlier}()},
\code{\link{identify_privacythreshold}()},
\code{\link{identify_query}()},
\code{\link{identify_shifts_wp}()},
\code{\link{identify_shifts}()},
\code{\link{identify_tenure}()},
\code{\link{remove_outliers}()},
\code{\link{standardise_pq}()},
\code{\link{subject_validate_report}()},
\code{\link{subject_validate}()},
\code{\link{track_HR_change}()},
\code{\link{validation_report}()}
}
\concept{Data Validation}
