% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/copy_df.R
\name{copy_df}
\alias{copy_df}
\title{Copy a data frame to clipboard for pasting in Excel}
\usage{
copy_df(x, row.names = FALSE, col.names = TRUE, quietly = FALSE, ...)
}
\arguments{
\item{x}{Data frame to be passed through. Cannot contain list-columns or
nested data frames.}

\item{row.names}{A logical vector for specifying whether to allow row names.
Defaults to \code{FALSE}.}

\item{col.names}{A logical vector for specifying whether to allow column
names. Defaults to \code{FALSE}.}

\item{quietly}{Set this to TRUE to not print data frame on console}

\item{...}{Additional arguments for write.table().}
}
\value{
Copies a data frame to the clipboard with no return value.
}
\description{
This is a pipe-optimised function, that feeds into \code{wpa::export()},
but can be used as a stand-alone function.

Based on the original function from
\url{https://github.com/martinctc/surveytoolbox}.
}
\seealso{
Other Import and Export: 
\code{\link{create_dt}()},
\code{\link{export}()},
\code{\link{import_to_fst}()},
\code{\link{import_wpa}()},
\code{\link{standardise_pq}()}
}
\concept{Import and Export}
