% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IV_by_Period.R
\name{IV_by_period}
\alias{IV_by_period}
\title{Identify the WPA metrics that have the biggest change between two
periods.}
\usage{
IV_by_period(
  data,
  before_start = min(as.Date(data$Date, "\%m/\%d/\%Y")),
  before_end,
  after_start = as.Date(before_end) + 1,
  after_end = max(as.Date(data$Date, "\%m/\%d/\%Y")),
  mybins = 10,
  return = "table"
)
}
\arguments{
\item{data}{Person Query as a dataframe including date column named "Date"
This function assumes the data format is \code{MM/DD/YYYY} as is standard in a
Workplace Analytics query output.}

\item{before_start}{Start date of "before" time period in \code{YYYY-MM-DD}.
Defaults to earliest date in dataset.}

\item{before_end}{End date of "before" time period in \code{YYYY-MM-DD}}

\item{after_start}{Start date of "after" time period in \code{YYYY-MM-DD}.
Defaults to day after before_end.}

\item{after_end}{End date of "after" time period in \code{YYYY-MM-DD}. Defaults to
latest date in dataset.}

\item{mybins}{Number of bins to cut the data into for Information Value
analysis. Defaults to 10.}

\item{return}{String specifying what to return. The current only valid
option is \code{"table"}.}
}
\value{
data frame containing all the variables and the corresponding Information
Value.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

This function uses the Information Value algorithm to predict
which Workplace Analytics metrics are most explained by the change in dates.
}
\examples{
\donttest{
# Returns a data frame
sq_data \%>\%
  IV_by_period(
    before_start = "2019-12-15",
    before_end = "2019-12-29",
    after_start = "2020-01-05",
    after_end = "2020-01-26"
  )
}
}
\seealso{
Other Variable Association: 
\code{\link{IV_report}()},
\code{\link{create_IV}()},
\code{\link{plot_WOE}()}

Other Information Value: 
\code{\link{IV_report}()},
\code{\link{create_IV}()},
\code{\link{plot_WOE}()}

Other Time-series: 
\code{\link{create_line_asis}()},
\code{\link{create_line}()},
\code{\link{create_period_scatter}()},
\code{\link{create_trend}()},
\code{\link{period_change}()}
}
\author{
Mark Powers \href{mailto:mark.powers@microsoft.com}{mark.powers@microsoft.com}
}
\concept{Information Value}
\concept{Time-series}
\concept{Variable Association}
