% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anlz_avgseason.R
\name{anlz_avgseason}
\alias{anlz_avgseason}
\title{Extract period (seasonal) averages from fitted GAM}
\usage{
anlz_avgseason(mod, doystr = 1, doyend = 364)
}
\arguments{
\item{mod}{input model object as returned by \code{\link{anlz_gam}}}

\item{doystr}{numeric indicating start Julian day for extracting averages}

\item{doyend}{numeric indicating ending Julian day for extracting averages}
}
\value{
A data frame of period averages
}
\description{
Extract period (seasonal) averages from fitted GAM
}
\examples{
library(dplyr)

# data to model
tomod <- rawdat \%>\%
  filter(station \%in\% 34) \%>\%
  filter(param \%in\% 'chl') \%>\% 
  filter(yr > 2015)

mod <- anlz_gam(tomod, trans = 'log10')
anlz_avgseason(mod, doystr = 90, doyend = 180)
}
\concept{analyze}
