% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotW2Leg.R
\name{plotW2Leg}
\alias{plotW2Leg}
\title{x-y plot with 2 legends}
\usage{
plotW2Leg(
  dat,
  useCol = c("logp", "slope", "medAbund", "startFr"),
  tit = NULL,
  subTi = NULL,
  subCex = 0.9,
  pch = 21:25,
  xlim = NULL,
  ylim = NULL,
  xlab = NULL,
  ylab = NULL,
  ablines = NULL,
  legendloc = "topright",
  txtLegend = NULL,
  histLoc = "bottomleft",
  legHiTi = NULL,
  silent = TRUE,
  callFrom = NULL
)
}
\arguments{
\item{dat}{(matrix or data.frame) main input}

\item{useCol}{(character or integer) columns form \code{dat}: The 1st and 2nd column are used as x- and y-axis}

\item{tit}{(character) optional custom title}

\item{subTi}{(character) optional custom subtitle}

\item{subCex}{(numeric) cex-like expansion factor for subtitle (see also \code{\link[graphics]{par}})}

\item{pch}{(integer) symbols to use for plotting (see also \code{\link[graphics]{par}}), will be associated to 4th column of \code{useCol}}

\item{xlim}{(numeric, length=2) x- axis limits (see also \code{\link[graphics]{par}})}

\item{ylim}{(numeric, length=2) y- axis limits (see also \code{\link[graphics]{par}})}

\item{xlab}{(character) custom x-axis label}

\item{ylab}{(character) custom x-axis label}

\item{ablines}{(list) optional horzontal and/or vertical gray dashed guide-lines}

\item{legendloc}{(character) location of legend (of symbols)}

\item{txtLegend}{(character) optional label for legend (of symbols)}

\item{histLoc}{(character) location of histomgram-legend (of 3rd column of \code{useCol})}

\item{legHiTi}{(character) optional title for histomgram-legend}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
graphical output only
}
\description{
This is a modified version of \code{\link[base]{plot}} for 2-dimensional data,
allowing to choose symbols and colors of points according to an additional columns of \code{dat}.
}
\examples{
x1 <- cbind(x=c(2,1:7), y=8:1 +runif(8), grade=rep(1:4,2))
plotW2Leg(x1,useCol=c("x","y","y","grade"))
}
\seealso{
\code{\link[base]{plot}}
}
