% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getValuesByUnique.R
\name{getValuesByUnique}
\alias{getValuesByUnique}
\title{Print matrix-content as plot}
\usage{
getValuesByUnique(dat, datUniq = NULL, asIndex = FALSE,
  silent = FALSE, callFrom = NULL)
}
\arguments{
\item{dat}{(numeric or character) main long input, must have names}

\item{datUniq}{(numeric or character) will be used to impose values on \code{dat}, must have names that should match names (at least partially) from \code{dat}}

\item{asIndex}{(logical) if \code{TRUE} index values will be returned instead of replacing values}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
vector of length \code{dat} with imposed values, or index values if \code{asIndex=TRUE}
}
\description{
When data have repeated elements (defined by names inside the vector), it may be advantageous to run some operations 
only on a unique set of the initial data, or somtimes all repeated occurances need to be replaced by a common (summarizing) value.
This function allows to re-introduce new values from on second vector with unique names, to return a final vector of initial input-length and order of names (elements) like initial, too.
Normally the user would provide 'datUniq' (without repeated names) containing new values which will be expanded to structure of 'dat', 
if 'datUniq' is not provided a vector with unique names will be made using the first occurance of repeated value(s).
For more complex cases the indexing relative to 'datUniq' can be returned (setting \code{asIndex=TRUE}).
Note: If not all names of 'dat' are found in 'datUniq' the missing spots will be returned as \code{NA}.
}
\examples{
dat <- 11:19
names(dat) <- letters[c(6:3,2:4,8,3)]
## let's make a 'datUniq' with the mean of repeated values :
datUniq <- round(tapply(dat,names(dat),mean),1)
## now propagate the mean values to the full vector
getValuesByUnique(dat,datUniq)
cbind(ini=dat,firstOfRep=getValuesByUnique(dat,datUniq),
  indexUniq=getValuesByUnique(dat,datUniq,asIn=TRUE))
}
\seealso{
\code{\link[base]{unique}}, \code{\link{findRepeated}}, \code{\link{correctToUnique}}, \code{\link{treatTxtDuplicates}}
}
