% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumNAperGroup.R
\name{sumNAperGroup}
\alias{sumNAperGroup}
\title{Count number of NAs per sub-set of columns}
\usage{
sumNAperGroup(x, grp, asRelative = FALSE)
}
\arguments{
\item{x}{matrix or data.frame which may contain \code{NA}s}

\item{grp}{factor describing which column of 'dat' belongs to which group}

\item{asRelative}{(logical) return as count of \code{NA}s per row and group}
}
\value{
integer vector with count of \code{NA}s per group
}
\description{
This function will count the number of \code{NA}s per group (defined by argument \code{grp}) while summing over all lines of a matrix or data.frame.
The row-position has no influence on the counting.
Using the argument \code{asRelative=TRUE} the result will be given as (average) number of \code{NA}s per row and group.
}
\examples{
mat <- matrix(1:25, ncol=5) 
mat[lower.tri(mat)] <- NA
sumNAperGroup(mat, rep(1:2,c(3,2)))
sumNAperGroup(mat, rep(1:2,c(3,2)), asRelative=TRUE)

}
\seealso{
\code{\link[base]{NA}}, filter \code{NA}s by line \code{\link{presenceFilt}}
}
