% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readVarColumns.R
\name{readVarColumns}
\alias{readVarColumns}
\title{Read tabular content of files with variable number of columns}
\usage{
readVarColumns(
  fiName,
  path = NULL,
  sep = "\\t",
  header = TRUE,
  emptyFields = NA,
  refCo = NULL,
  supNa = NULL,
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{fiName}{(character) file-name}

\item{path}{(character) optional path}

\item{sep}{(character) separator (between columns)}

\item{header}{(logical) indicating whether the file contains the names of the variables as its first line.}

\item{emptyFields}{(\code{NA} or character) missing headers will be replaced by the content of 'emptyFields', if \code{NA} the last column-name will be re-used and a counter added}

\item{refCo}{(integer) for custom choice of column to be used as row-names (default will use 1st text-column)}

\item{supNa}{(character) base for constructing name for columns wo names (+counter starting at 2), default column-name to left of 1st col wo colname}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of message(s) produced}
}
\value{
matrix (character or numeric)
}
\description{
Reading the content of files where the number of separators (eg tabulation) is variable poses problems with traditional methods for reding files, like  \code{\link[utils]{read.table}}.
This function reads each line independently and then parses all separators therein. The first line is assumed to be column-headers.
Finally, all data will be returned in a matrix adopted to the line with most separators and if the number of column-headers is insufficient, new (unique) column-headers will be generated.
Thus, the lines may contain different number of elements, empty elements (ie tabular fields) will always get added to right of data read 
and their content will be as defined by argument \code{emptyFields} (default \code{NA}).
}
\details{
Note, this functions assumes one line of header and at least one line of data !
Note, for numeric data the comma is assumed to be US-Style (as '.').
Note, that it is assumed, that any missing fields for the complete tabular view are missing on the right (ie at the end of line) !
}
\examples{
path1 <- system.file("extdata",package="wrMisc")
fiNa <- "Names1.tsv"
datAll <- readVarColumns(fiName=file.path(path1,fiNa))
str(datAll)
}
\seealso{
for regular 'complete' data \code{\link[utils]{read.table}}
}
