% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/packageDownloadStat.R
\name{packageDownloadStat}
\alias{packageDownloadStat}
\title{Simple Package Download Statistics from CRAN}
\usage{
packageDownloadStat(
  queryPackages = c("wrMisc", "wrProteo", "cif", "bcv", "FinCovRegularization"),
  countUrl = "http://www.datasciencemeta.com/rpackages",
  refQuant = (1:10)/10,
  figure = TRUE,
  log = "",
  silent = FALSE,
  callFrom = NULL
)
}
\arguments{
\item{queryPackages}{(character or integer) package names of interest, if \code{integer}, n random packages will be picked by random}

\item{countUrl}{(character) the url where the dayly counts ara available}

\item{refQuant}{(numeric) add reference quantile values to output matrix}

\item{figure}{(logical) decide of figure should be printed}

\item{log}{(character) set count-axis of figure to linear or log-scale (by setting \code{log="y"})}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}
}
\value{
This function retuns a matrix with download counts (or NULL if the web-site can't be accessed or the query-packages are not found there)
}
\description{
This function allows accessing the most recent counts of package downloads availabale on http://www.datasciencemeta.com/rpackages, 
obtaining rank quantiles and to compare (multiple) given packages to the bulk data, optionally a plot can be drawn.
}
\details{
The task of checking the number of downloads for a given package has been addressed by several packages (eg dlstats, cranlogs, adjustedcranlogs).
Detailed articles on this subject have been published on R-Hub (https://blog.r-hub.io/2020/05/11/packagerank-intro/) and on 
R-bloggers (https://www.r-bloggers.com/2020/10/a-cran-downloads-experiment/).

This function only allows accessing the most recent counts as listed on the website of www.datasciencemeta.com .  
Please note, that reading all lines from the website may take a few seconds.
To get a better understanding of the counts read, reference quantiles for download-counts get added by default  (see argument \code{refQuant}). 
The (optional) figure can be drawn in linear scale (default, with minor zoom to lower number of counts) or in log (necessary for proper display of the entire range of counts), by setting the argument \code{log="y"}. 

The number of downloads counted by RStudio may not be a perfect measure for the actual usage/popularity of a given package,   
the articles cited above discuss this in more detail.
For example, multiple downloads from the same IP or subsequent downloads of multiple (older) versions of the same package are counted, too.
}
\examples{
## Let's try a microscopic test-file (NOT representative for true counts !!)
pack1 <- c("cif","bcv","FinCovRegularization","wrMisc","wrProteo")
testFi <- file.path(system.file("extdata",package="wrMisc"),"rpackagesMicro.html")
packageDownloadStat(pack1, countUrl=testFi, log="y", figure=FALSE)
## For real online counting simply drop the argument countUrl

}
\seealso{
\code{\link[cranlogs]{cran_downloads}}, \code{\link[packageRank]{packageRank}}
}
