% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readProtDiscovFile.R
\name{.plotQuantDistr}
\alias{.plotQuantDistr}
\title{Generic plotting of density distribution for quantitation import-functions}
\usage{
.plotQuantDistr(
  abund,
  quant,
  custLay = NULL,
  normalizeMeth = NULL,
  softNa = NULL,
  refLi,
  refLiIni = NULL,
  tit,
  silent = FALSE,
  callFrom = NULL,
  debug = FALSE
)
}
\arguments{
\item{abund}{(matrix or data.frame) abundance data, will be plottes as distribution}

\item{quant}{(matrix or data.frame) aoptional additional abundance data, to plot 2nd distribution, eg of normalized data}

\item{custLay}{(matrix) describing sammple-setup, typically produced by}

\item{normalizeMeth}{(charactert, length=1) name of normalization method (will be displayed in title of figure)}

\item{softNa}{(charactert, length=1) 2-letter abbreviation of name of quantitation-software (eg 'MQ')}

\item{refLi}{(integer) to display number reference lines}

\item{refLiIni}{(integer) to display initial number reference lines}

\item{tit}{(character) custom title}

\item{silent}{(logical) suppress messages}

\item{callFrom}{(character) allow easier tracking of messages produced}

\item{debug}{(logical) display additional messages for debugging}
}
\value{
This function returns logical value (if data were valid for plotting) and produces a density dustribution figure (if data were found valid)
}
\description{
This (low-level) function allows (generic) plotting of density distribution for quantitation import-functions
}
\examples{
set.seed(2018);  datT8 <- matrix(round(rnorm(800)+3,1), nc=8, dimnames=list(paste(
  "li",1:100,sep=""), paste(rep(LETTERS[1:3],c(3,3,2)),letters[18:25],sep="")))
.plotQuantDistr(datT8, quant=NULL, refLi=NULL, tit="Synthetic Data")
}
\seealso{
used in \code{readProtDiscovererFile},  \code{\link{readMaxQuantFile}}, \code{\link{readProlineFile}}, \code{\link{readFragpipeFile}}
}
