% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basefunctions.R
\name{FindVars}
\alias{FindVars}
\title{Find numeric index and names of columns based on patterns}
\usage{
FindVars(
  varnames,
  allnames = NULL,
  exact = FALSE,
  exclude = NA,
  casesensitive = TRUE,
  fixed = FALSE
)
}
\arguments{
\item{varnames}{Vector of pattern to look for.}

\item{allnames}{Vector of values to detect pattern in; by default, colnames(rawdata).}

\item{exact}{Partial matching or exact only (adding ^ and $)?}

\item{exclude}{Vector of pattern to exclude from found names.}

\item{casesensitive}{Logical if case is respected in matching (default FALSE: a<>A)}

\item{fixed}{Logical, match as is, argument is passed to \code{\link[=grep]{grep()}}.}
}
\value{
A list with index, names, backticked names, and symbols
}
\description{
\code{FindVars} looks up colnames (by default for data-frame rawdata)
based on parts of names, using regular expressions. Be warned that
special characters as e.g. \code{[} \code{(} need to be escaped or replaced by .
Exlusion rules may be specified as well.
}
\examples{
FindVars(varnames = c("^c", "g"), allnames = colnames(mtcars))
FindVars(varnames = c("^c", "g"), allnames = colnames(mtcars), exclude = "r")
rawdata <- mtcars
FindVars(varnames = c("^c", "g"))
}
