% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cf.R
\name{draw_frame}
\alias{draw_frame}
\title{Render a data.frame in build_frame format.}
\usage{
draw_frame(x, ..., time_format = "\%Y-\%m-\%d \%H:\%M:\%S",
  formatC_options = list())
}
\arguments{
\item{x}{data.frame (atomic types, with at least 1 row and 1 column).}

\item{...}{not used for values, forces later arguments to bind by name.}

\item{time_format}{character, format for "POSIXt" classes.}

\item{formatC_options}{named list, options for formatC()- used on numerics.}
}
\value{
chracter
}
\description{
Render a data.frame in build_frame format.
}
\examples{

tc_name <- "training"
x <- build_frame(
  "measure"                   , tc_name, "validation", "idx" |
  "minus binary cross entropy", 5      , 7           , 1L    |
  "accuracy"                  , 0.8    , 0.6         , 2L    )
print(x)
cat(draw_frame(x))

}
\seealso{
\code{\link{build_frame}},  \code{\link{qchar_frame}}
}
