% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VectorizeM.R
\name{vapplym}
\alias{vapplym}
\title{Memoizing wrapper for vapply.}
\usage{
vapplym(X, FUN, FUN.VALUE, ..., USE.NAMES = TRUE)
}
\arguments{
\item{X}{list or vector of inputs}

\item{FUN}{function to apply}

\item{FUN.VALUE}{type of vector to return}

\item{...}{additional arguments passed to lapply}

\item{USE.NAMES}{passed to vapply}
}
\value{
vector of results.
}
\description{
Memoizing wrapper for vapply.
}
\examples{

fs <- function(x) { x <- x[[1]]; print(paste("see", x)); sin(x) }
# should only print "see" twice, not 6 times
vapplym(c(0, 1, 1, 0, 0, 1), fs, numeric(1))

}
\seealso{
\code{\link{VectorizeM}}, \code{\link{lapplym}}
}
