% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_tests.R
\name{single_lag_test}
\alias{single_lag_test}
\title{Single-Lag Hypothesis Test}
\usage{
single_lag_test(f_data, lag = 1, alpha = 0.05, iid = FALSE,
  M = NULL, low_disc = FALSE, bootstrap = FALSE,
  block_size = "adaptive", straps = 300, moving = FALSE,
  suppress_raw_output = FALSE, suppress_print_output = FALSE)
}
\arguments{
\item{f_data}{The functional data matrix with observed functions in the columns}

\item{lag}{Positive integer value. The lag to use to compute the single lag test statistic.}

\item{alpha}{Numeric value between 0 and 1 specifying the significance level to be used in the specified
hypothesis test. The default value is 0.05. Note, the significance value is only ever used to compute the
1-alpha quantile of the limiting distribution of the specified test's test statistic.}

\item{iid}{A Boolean value, FALSE by default. If given TRUE, the hypothesis test will use a strong-white
noise assumption (instead of a weak-white noise assumption).}

\item{M}{Positive integer value. Number of Monte-Carlo simulations for the Welch-Satterthwaite approximation.}

\item{low_disc}{A Boolean value, FALSE by default. If given TRUE, uses low-discrepancy sampling in the
Monte-Carlo method. Note, low-discrepancy sampling will yield deterministic results.
Requires the 'fOptions' package.}

\item{bootstrap}{A Boolean value, FALSE by default If given TRUE, the hypothesis test is done by
approximating the limiting distribution of the test statistic via a block bootstrap process.}

\item{block_size}{A positive Integer value, with the default value being computed via the adaptive
bandwidth selection method in the "spectral" test. Determines the block size (of each block in each
bootstrap sample) if the test is being bootstrapped.}

\item{straps}{A positive Integer, with a default value of 300. Determines the number of bootstrap samples
to take if the test is being bootstrapped. Only used if 'bootstrap' == TRUE.}

\item{moving}{A Boolean value, FALSE by default If given TRUE, the performed block bootstrap will be moving
rather than stationary.}

\item{suppress_raw_output}{Boolean value, FALSE by default. If TRUE, the function will not return the list
containing the p-value, quantile, and statistic.}

\item{suppress_print_output}{Boolean value, FALSE by default. If TRUE, the function will not print any
output to the console.}
}
\value{
If suppress_raw_output = FALSE, a list containing the test statistic, the 1-alpha quantile of the
limiting distribution, and the p-value computed from the specified hypothesis test. Also prints output
containing a short description of the test, the p-value, and additional information about the test if
suppress_print_output = FALSE.
}
\description{
\code{single_lag_test} Computes the single-lag hypothesis test at a single user-specified lag.
}
\details{
The "single-lag" portmanteau test is based on the sample autocovariance function computed from the
functional data. This test assesses the significance of lagged autocovariance operators at a single,
user-specified lag h. More specifically, it tests the null hypothesis that the lag-h autocovariance
operator is equal to 0. This test is designed for stationary functional time-series, and is valid under
conditional heteroscedasticity conditions.
}
\examples{
f <- far_1_S(150, 50, S = 0.75)
single_lag_test(f, lag = 1)
single_lag_test(f, lag = 2, M=100)

}
\references{
[1] Kokoszka P., & Rice G., & Shang H.L. (2017). Inference for the autocovariance of a functional time series
under conditional heteroscedasticity. Journal of Multivariate Analysis, 162, 32-50.
}
