% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addtemplate_x3p.R
\name{x3p_add_meta}
\alias{x3p_add_meta}
\alias{addtemplate_x3p}
\title{Add/change xml meta information in x3p object}
\usage{
x3p_add_meta(x3p, template = NULL)

addtemplate_x3p(x3p, template = NULL)
}
\arguments{
\item{x3p}{x3p object}

\item{template}{file path to xml template, use NULL for in-built package template}
}
\description{
Use a specified template to overwrite the general info in the x3p object (and structure of the feature info, if needed).
}
\examples{
logo <- x3p_read(system.file("csafe-logo.x3p", package="x3ptools"))
# exchange meta information for general x3p information:
logo <- x3p_add_meta(logo, template = system.file("templateXML.xml", package="x3ptools"))
logo$general.info
}
