% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/query.R
\name{xQTLquery_tissue}
\alias{xQTLquery_tissue}
\title{Fetch all details of a specified tissue or all tissues}
\usage{
xQTLquery_tissue(tissueName = "", datasetId = "gtex_v8")
}
\arguments{
\item{tissueName}{Tissue name, tissue ID or tissue site name. Default return all tissues' information. Can be choonse from \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{datasetId}{(character) options: "gtex_v8" (default), "gtex_v7".}
}
\value{
A data.table object.
}
\description{
Information includes tissue IDs, number of RNA-Seq samples, number of RNA-Seq samples with genotype, number of expressed genes, number of eGenes. Also includes tissueSiteDetail ID, name, abbreviation, uberon ID, and standard tissue colors. TissueSiteDetails are grouped by TissueSites. By default, this service reports from the latest GTEx release.
}
\examples{
tissueAll <- xQTLquery_tissue(datasetId="gtex_v7")
BrainInfo <- xQTLquery_tissue("Brain", datasetId="gtex_v7")
}
