% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download.R
\name{xQTLdownload_geneMedExp}
\alias{xQTLdownload_geneMedExp}
\title{Download median expressions for multiple genes in a specified tissue}
\usage{
xQTLdownload_geneMedExp(
  genes = "",
  geneType = "auto",
  tissueSiteDetail = "",
  recordPerChunk = 150
)
}
\arguments{
\item{genes}{(character string or a character vector) gene symbols or gencode ids (versioned or unversioned are both supported).}

\item{geneType}{(character) options: "auto","geneSymbol" or "gencodeId". Default: "auto".}

\item{tissueSiteDetail}{(character) details of tissues in GTEx can be listed using \code{tissueSiteDetailGTExv8} or \code{tissueSiteDetailGTExv7}}

\item{recordPerChunk}{(integer) number of records fetched per request (default: 150).}
}
\value{
A data.table object.
}
\description{
Download median expressions for multiple genes in a specified tissue
}
\examples{
geneMedExp <- xQTLdownload_geneMedExp(genes="LYNX1")
geneMedExp <- xQTLdownload_geneMedExp(genes=c("TP53", "IRF5"))
}
